/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.apexcore.lib.util.EventBusHelper;

public final class ProfileHelper {
    private static final UUID UUID_EXAMPLE = UUID.randomUUID();
    private static final ProfileHelper INSTANCE = new ProfileHelper();
    public static final GameProfile DUMMY_PROFILE = new GameProfile(UUID_EXAMPLE, "steve");
    private final Map<String, GameProfile> gameProfileCache = Collections.synchronizedMap(Maps.newHashMap());
    private final Map<UUID, GameProfile> gameProfileCacheUUID = Collections.synchronizedMap(Maps.newHashMap());
    @Nullable
    private PlayerProfileCache profileCache;
    @Nullable
    private MinecraftSessionService sessionService;

    private GameProfile getGameProfile0(@Nullable UUID playerId, @Nullable String playerName) {
        Property property;
        GameProfile profile;
        Validate.isTrue((playerId != null || playerName != null ? 1 : 0) != 0);
        if (playerName != null && this.gameProfileCache.containsKey(playerName)) {
            return this.gameProfileCache.get(playerName);
        }
        if (playerId != null && this.gameProfileCacheUUID.containsKey(playerId)) {
            return this.gameProfileCacheUUID.get(playerId);
        }
        if (this.profileCache == null || this.sessionService == null) {
            if (FMLEnvironment.dist.isDedicatedServer()) {
                MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
                this.sessionService = currentServer.func_147130_as();
                this.profileCache = currentServer.func_152358_ax();
            } else {
                this.setClientProfileLookupObjects();
            }
        }
        Validate.notNull((Object)this.profileCache);
        Validate.notNull((Object)this.sessionService);
        GameProfile gameProfile = profile = playerId != null ? this.profileCache.func_152652_a(playerId) : this.profileCache.func_152655_a(playerName);
        if (profile == null) {
            profile = this.sessionService.fillProfileProperties(new GameProfile(playerId, playerName), true);
        }
        if ((property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null)) == null) {
            profile = this.sessionService.fillProfileProperties(profile, true);
        }
        this.gameProfileCache.put(profile.getName(), profile);
        this.gameProfileCacheUUID.put(profile.getId(), profile);
        return profile;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setClientProfileLookupObjects() {
        Minecraft mc = Minecraft.func_71410_x();
        YggdrasilAuthenticationService authenticationService = new YggdrasilAuthenticationService(mc.func_110437_J(), UUID.randomUUID().toString());
        GameProfileRepository profileRepository = authenticationService.createProfileRepository();
        this.sessionService = authenticationService.createMinecraftSessionService();
        this.profileCache = new PlayerProfileCache(profileRepository, new File(mc.field_71412_D, MinecraftServer.field_152367_a.getName()));
    }

    public static GameProfile getGameProfile(@Nullable UUID playerId, @Nullable String playerName) {
        return INSTANCE.getGameProfile0(playerId, playerName);
    }

    public static void setup() {
        Validate.isTrue((boolean)ModLoadingContext.get().getActiveContainer().getModId().equals("apexcore"));
        EventBusHelper.addEnqueuedListener(FMLClientSetupEvent.class, event -> INSTANCE.setClientProfileLookupObjects());
        EventBusHelper.addListener(FMLServerAboutToStartEvent.class, event -> {
            MinecraftServer server = event.getServer();
            ProfileHelper.INSTANCE.profileCache = server.func_152358_ax();
            ProfileHelper.INSTANCE.sessionService = server.func_147130_as();
        });
    }
}

