/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.multiblock;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.DistExecutor;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlock;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockFactory;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockPattern;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.BlockEntityBuilder;
import xyz.apex.forge.utility.registrator.builder.ItemBuilder;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.factory.BlockEntityFactory;
import xyz.apex.forge.utility.registrator.factory.item.BlockItemFactory;
import xyz.apex.java.utility.nullness.NonnullBiConsumer;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NonnullUnaryOperator;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.providers.DataGenContext;
import xyz.apex.repack.com.tterrag.registrate.providers.ProviderType;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.RegistrateRecipeProvider;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import xyz.apex.repack.com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public class MultiBlockBuilder<OWNER extends AbstractRegistrator<OWNER>, BLOCK extends MultiBlock, PARENT>
extends RegistratorBuilder<OWNER, Block, BLOCK, PARENT, MultiBlockBuilder<OWNER, BLOCK, PARENT>, BlockEntry<BLOCK>> {
    private final MultiBlockFactory<BLOCK> blockFactory;
    private NonnullSupplier<AbstractBlock.Properties> initialProperties;
    private NonnullUnaryOperator<AbstractBlock.Properties> propertiesModifier = NonnullUnaryOperator.identity();
    private final List<NonnullSupplier<NonnullSupplier<RenderType>>> renderTypes = Lists.newArrayList();
    @Nullable
    private NonnullSupplier<NonnullSupplier<IBlockColor>> colorHandler = null;
    @Nullable
    private ItemBuilder<OWNER, ?, MultiBlockBuilder<OWNER, BLOCK, PARENT>> itemBuilder = null;
    @Nullable
    private BlockEntityBuilder<OWNER, ?, MultiBlockBuilder<OWNER, BLOCK, PARENT>> blockEntityBuilder = null;
    private final MultiBlockPattern pattern;

    public MultiBlockBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, MultiBlockFactory<BLOCK> blockFactory, NonnullSupplier<AbstractBlock.Properties> initialProperties, MultiBlockPattern pattern) {
        super(owner, parent, registryName, callback, Block.class, BlockEntry::new, BlockEntry::cast);
        this.pattern = pattern;
        this.blockFactory = blockFactory;
        this.initialProperties = initialProperties;
        this.onRegister(this::onRegister);
        this.defaultBlockState().defaultLoot().defaultLang();
    }

    private void onRegister(BLOCK block) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            OneTimeEventReceiver.addModListener(ColorHandlerEvent.Block.class, event -> this.registerBlockColor((ColorHandlerEvent.Block)event, (BLOCK)((Object)block)));
            this.registerRenderTypes(block);
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerBlockColor(ColorHandlerEvent.Block event, BLOCK block) {
        if (this.colorHandler != null) {
            event.getBlockColors().func_186722_a(this.colorHandler.get().get(), new Block[]{block});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderTypes(BLOCK block) {
        if (this.renderTypes.size() == 1) {
            RenderType renderType = this.renderTypes.get(0).get().get();
            RenderTypeLookup.setRenderLayer(block, (RenderType)renderType);
        } else if (this.renderTypes.size() > 1) {
            ImmutableSet renderTypes = (ImmutableSet)this.renderTypes.stream().map(NonnullSupplier::get).map(NonnullSupplier::get).collect(ImmutableSet.toImmutableSet());
            RenderTypeLookup.setRenderLayer(block, arg_0 -> ((ImmutableSet)renderTypes).contains(arg_0));
        }
    }

    @Override
    @NonnullType
    protected BLOCK createEntry() {
        if (this.itemBuilder != null) {
            this.copyMappingsTo(this.itemBuilder);
        }
        if (this.blockEntityBuilder != null) {
            this.copyMappingsTo(this.blockEntityBuilder);
        }
        AbstractBlock.Properties properties = this.initialProperties.get();
        properties = (AbstractBlock.Properties)this.propertiesModifier.apply(properties);
        return this.blockFactory.create(properties, this.pattern);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> properties(NonnullUnaryOperator<AbstractBlock.Properties> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200945_a((Material)material);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, DyeColor materialColor) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200952_a((Material)material, (DyeColor)materialColor);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, MaterialColor materialColor) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, NonnullFunction<BlockState, MaterialColor> materialColorFactory) {
        this.initialProperties = () -> AbstractBlock.Properties.func_235836_a_((Material)material, (Function)materialColorFactory);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> initialProperties(NonnullSupplier<? extends Block> block) {
        this.initialProperties = () -> AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)block.get()));
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> noCollission() {
        return this.properties(AbstractBlock.Properties::func_200942_a);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> noOcclusion() {
        return this.properties(AbstractBlock.Properties::func_226896_b_);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> harvestLevel(int harvestLevel) {
        return this.properties(properties -> properties.harvestLevel(harvestLevel));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> harvestTool(ToolType harvestTool) {
        return this.properties(properties -> properties.harvestTool(harvestTool));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> friction(float friction) {
        return this.properties(properties -> properties.func_200941_a(friction));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> speedFactor(float speedFactor) {
        return this.properties(properties -> properties.func_226897_b_(speedFactor));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> jumpFactor(float jumpFactor) {
        return this.properties(properties -> properties.func_226898_c_(jumpFactor));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> sound(SoundType soundType) {
        return this.properties(properties -> properties.func_200947_a(soundType));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> lightLevel(ToIntFunction<BlockState> lightLevelFunction) {
        return this.properties(properties -> properties.func_235838_a_(lightLevelFunction));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> strength(float destroyTime, float explosionResistance) {
        return this.properties(properties -> properties.func_200948_a(destroyTime, explosionResistance));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> instabreak() {
        return this.properties(AbstractBlock.Properties::func_200946_b);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> strength(float strength) {
        return this.properties(properties -> properties.func_200943_b(strength));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> randomTicks() {
        return this.properties(AbstractBlock.Properties::func_200944_c);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> dynamicShape() {
        return this.properties(AbstractBlock.Properties::func_208770_d);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> noDrops() {
        return this.properties(AbstractBlock.Properties::func_222380_e);
    }

    @Deprecated
    public MultiBlockBuilder<OWNER, BLOCK, PARENT> dropsLike(Block block) {
        return this.properties(properties -> properties.func_222379_b(block));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> dropsLike(NonnullSupplier<? extends Block> block) {
        return this.properties(properties -> properties.lootFrom((Supplier)block));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> air() {
        return this.properties(AbstractBlock.Properties::func_235859_g_);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isValidSpawn(AbstractBlock.IExtendedPositionPredicate<EntityType<?>> extendedPositionPredicate) {
        return this.properties(properties -> properties.func_235827_a_(extendedPositionPredicate));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isRedstoneConductor(AbstractBlock.IPositionPredicate positionPredicate) {
        return this.properties(properties -> properties.func_235828_a_(positionPredicate));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isSuffocating(AbstractBlock.IPositionPredicate positionPredicate) {
        return this.properties(properties -> properties.func_235842_b_(positionPredicate));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> isViewBlocking(AbstractBlock.IPositionPredicate positionPredicate) {
        return this.properties(properties -> properties.func_235847_c_(positionPredicate));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> hasPostProcess(AbstractBlock.IPositionPredicate positionPredicate) {
        return this.properties(properties -> properties.func_235852_d_(positionPredicate));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> emissiveRendering(AbstractBlock.IPositionPredicate positionPredicate) {
        return this.properties(properties -> properties.func_235856_e_(positionPredicate));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> requiresCorrectToolForDrops() {
        return this.properties(AbstractBlock.Properties::func_235861_h_);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> addRenderType(NonnullSupplier<NonnullSupplier<RenderType>> renderType) {
        this.renderTypes.add(renderType);
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> simpleItem() {
        return this.simpleItem(BlockItemFactory.forBlock());
    }

    public <ITEM extends BlockItem> MultiBlockBuilder<OWNER, BLOCK, PARENT> simpleItem(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        return (MultiBlockBuilder)this.item(blockItemFactory).build();
    }

    public ItemBuilder<OWNER, BlockItem, MultiBlockBuilder<OWNER, BLOCK, PARENT>> item() {
        return this.item(BlockItemFactory.forBlock());
    }

    public <ITEM extends BlockItem> ItemBuilder<OWNER, ITEM, MultiBlockBuilder<OWNER, BLOCK, PARENT>> item(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        if (this.itemBuilder == null) {
            this.itemBuilder = this.owner.blockItem(this.getName(), this, this.toSupplier(), blockItemFactory);
        }
        return this.itemBuilder;
    }

    public <BLOCK_ENTITY extends TileEntity> MultiBlockBuilder<OWNER, BLOCK, PARENT> simpleBlockEntity(BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        return (MultiBlockBuilder)this.blockEntity(blockEntityFactory).build();
    }

    public <BLOCK_ENTITY extends TileEntity> BlockEntityBuilder<OWNER, BLOCK_ENTITY, MultiBlockBuilder<OWNER, BLOCK, PARENT>> blockEntity(BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        if (this.blockEntityBuilder == null) {
            this.blockEntityBuilder = this.owner.blockEntity(this.getName(), this, blockEntityFactory).validBlock(() -> (MultiBlock)((Object)((Object)this.asSupplier().get())));
        }
        return this.blockEntityBuilder;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> color(NonnullSupplier<NonnullSupplier<IBlockColor>> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> defaultBlockState() {
        return this.blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.getEntry()));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> blockState(NonnullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateBlockstateProvider> consumer) {
        return (MultiBlockBuilder)this.setDataGenerator(ProviderType.BLOCKSTATE, consumer);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> defaultLang() {
        return (MultiBlockBuilder)this.lang(Block::func_149739_a);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> lang(String name) {
        return (MultiBlockBuilder)this.lang(Block::func_149739_a, name);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> defaultLoot() {
        return this.loot(BlockLootTables::func_218492_c);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> loot(NonnullBiConsumer<RegistrateBlockLootTables, BLOCK> consumer) {
        return (MultiBlockBuilder)this.setDataGenerator(ProviderType.LOOT, (ctx, provider) -> provider.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, lootTables -> consumer.accept((RegistrateBlockLootTables)lootTables, (Object)ctx.getEntry())));
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> recipe(NonnullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateRecipeProvider> consumer) {
        return (MultiBlockBuilder)this.setDataGenerator(ProviderType.RECIPE, consumer);
    }

    @SafeVarargs
    public final MultiBlockBuilder<OWNER, BLOCK, PARENT> tag(ITag.INamedTag<Block> ... tags) {
        return (MultiBlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @SafeVarargs
    public final MultiBlockBuilder<OWNER, BLOCK, PARENT> removeTag(ITag.INamedTag<Block> ... tags) {
        return (MultiBlockBuilder)this.removeTag(ProviderType.BLOCK_TAGS, tags);
    }

    public MultiBlockBuilder<OWNER, BLOCK, PARENT> lang(String languageKey, String localizedValue) {
        return (MultiBlockBuilder)this.lang(languageKey, Block::func_149739_a, localizedValue);
    }
}

