/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.multiblock;

import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.StateContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import xyz.apex.forge.apexcore.lib.multiblock.MultiBlockPattern;

public class MultiBlock
extends Block {
    protected final MultiBlockPattern pattern;

    public MultiBlock(AbstractBlock.Properties properties, MultiBlockPattern pattern) {
        super(properties);
        this.pattern = pattern;
        MultiBlock.replaceStateContainer(this);
    }

    @Nullable
    public final BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState defaultBlockState = this.func_176223_P();
        BlockState placementState = this.pattern.getStateForPlacement(ctx, defaultBlockState);
        if (placementState != null) {
            placementState = this.getPlacementState(ctx, placementState);
        }
        return placementState;
    }

    public final boolean func_196260_a(BlockState blockState, IWorldReader level, BlockPos pos) {
        return this.pattern.canSurvive(level, pos, blockState) && this.canSurviveAdditional(level, pos, blockState);
    }

    protected boolean canSurviveAdditional(IWorldReader level, BlockPos pos, BlockState blockState) {
        return true;
    }

    @Nullable
    protected BlockState getPlacementState(BlockItemUseContext ctx, BlockState defaultBlockState) {
        return defaultBlockState;
    }

    @OverridingMethodsMustInvokeSuper
    public void func_220082_b(BlockState blockState, World level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        this.pattern.onPlace(blockState, level, pos, oldBlockState, isMoving);
    }

    @OverridingMethodsMustInvokeSuper
    public void func_196243_a(BlockState blockState, World level, BlockPos pos, BlockState oldBlockState, boolean isMoving) {
        if (!blockState.func_203425_a(oldBlockState.func_177230_c())) {
            this.pattern.onRemove(blockState, level, pos, oldBlockState, isMoving);
        }
        super.func_196243_a(blockState, level, pos, oldBlockState, isMoving);
    }

    public final MultiBlockPattern getMultiBlockPattern() {
        return this.pattern;
    }

    public static void replaceStateContainer(MultiBlock block) {
        StateContainer.Builder builder = new StateContainer.Builder((Object)block);
        block.func_206840_a(builder);
        block.pattern.createBlockStateDefinition((StateContainer.Builder<Block, BlockState>)builder);
        StateContainer stateDefinition = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        block.func_180632_j(block.pattern.registerDefaultState((BlockState)stateDefinition.func_177621_b()));
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)((Object)block), (Object)stateDefinition, (String)"field_176227_L");
    }
}

