/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.mutable.MutableObject;
import xyz.apex.forge.apexcore.lib.util.VectorHelper;
import xyz.apex.java.utility.nullness.NonnullFunction;

public final class VoxelShaper {
    public static final NonnullFunction<Direction, Vector3d> DEFAULT_ROTATION_VALUES = dir -> new Vector3d(dir == Direction.UP ? 0.0 : (Direction.Plane.VERTICAL.test(dir) ? 180.0 : 90.0), (double)(-VoxelShaper.horizontalAngleFromDirection(dir)), 0.0);
    public static final NonnullFunction<Direction, Vector3d> HORIZONTAL_ROTATION_VALUES = dir -> new Vector3d(0.0, (double)(-VoxelShaper.horizontalAngleFromDirection(dir)), 0.0);
    private final Map<Direction, VoxelShape> shapes = Maps.newEnumMap(Direction.class);

    public VoxelShape get(Direction facing) {
        return this.shapes.containsKey(facing) ? this.shapes.get(facing) : VoxelShapes.func_197868_b();
    }

    public VoxelShape get(Direction.Axis axis) {
        return this.get(VoxelShaper.axisAsFace(axis));
    }

    public VoxelShaper withVerticalShapes(VoxelShape source) {
        return this.with(source, Direction.UP).with(VoxelShaper.rotatedCopy(source, new Vector3d(180.0, 0.0, 0.0)), Direction.DOWN);
    }

    public VoxelShaper with(VoxelShape source, Direction facing) {
        this.shapes.put(facing, source);
        return this;
    }

    public static Direction axisAsFace(Direction.Axis axis) {
        return Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
    }

    public static float horizontalAngleFromDirection(Direction direction) {
        return (Math.max(direction.func_176736_b(), 0) & 3) * 90;
    }

    public static VoxelShaper forHorizontal(VoxelShape source, Direction facing) {
        return VoxelShaper.forDirectionsWithRotation(source, facing, (Iterable<Direction>)Direction.Plane.HORIZONTAL, HORIZONTAL_ROTATION_VALUES);
    }

    public static VoxelShaper forHorizontalAxis(VoxelShape source, Direction.Axis along) {
        return VoxelShaper.forDirectionsWithRotation(source, VoxelShaper.axisAsFace(along), Arrays.asList(Direction.SOUTH, Direction.EAST), HORIZONTAL_ROTATION_VALUES);
    }

    public static VoxelShaper forDirectional(VoxelShape source, Direction facing) {
        return VoxelShaper.forDirectionsWithRotation(source, facing, Lists.newArrayList((Object[])Direction.values()), DEFAULT_ROTATION_VALUES);
    }

    public static VoxelShaper forAxis(VoxelShape source, Direction.Axis axis) {
        return VoxelShaper.forDirectionsWithRotation(source, VoxelShaper.axisAsFace(axis), Arrays.asList(Direction.SOUTH, Direction.EAST, Direction.UP), DEFAULT_ROTATION_VALUES);
    }

    public static VoxelShaper forDirectionsWithRotation(VoxelShape source, Direction facing, Iterable<Direction> directions, NonnullFunction<Direction, Vector3d> usingValues) {
        VoxelShaper shaper = new VoxelShaper();
        for (Direction direction : directions) {
            shaper.with(VoxelShaper.rotate(source, facing, direction, usingValues), direction);
        }
        return shaper;
    }

    public static VoxelShape rotate(VoxelShape source, Direction from, Direction to, NonnullFunction<Direction, Vector3d> usingValues) {
        if (from == to) {
            return source;
        }
        return VoxelShaper.rotatedCopy(source, usingValues.apply(from).func_216371_e().func_178787_e(usingValues.apply(to)));
    }

    public static VoxelShape rotatedCopy(VoxelShape source, Vector3d rotation) {
        if (rotation.equals((Object)Vector3d.field_186680_a)) {
            return source;
        }
        MutableObject result = new MutableObject((Object)VoxelShapes.func_197880_a());
        Vector3d center = new Vector3d(8.0, 8.0, 8.0);
        source.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            Vector3d v1 = new Vector3d(x1, y1, z1).func_186678_a(16.0).func_178788_d(center);
            Vector3d v2 = new Vector3d(x2, y2, z2).func_186678_a(16.0).func_178788_d(center);
            v1 = VectorHelper.rotate(v1, (float)rotation.field_72450_a, Direction.Axis.X);
            v1 = VectorHelper.rotate(v1, (float)rotation.field_72448_b, Direction.Axis.Y);
            v1 = VectorHelper.rotate(v1, (float)rotation.field_72449_c, Direction.Axis.Z).func_178787_e(center);
            v2 = VectorHelper.rotate(v2, (float)rotation.field_72450_a, Direction.Axis.X);
            v2 = VectorHelper.rotate(v2, (float)rotation.field_72448_b, Direction.Axis.Y);
            v2 = VectorHelper.rotate(v2, (float)rotation.field_72449_c, Direction.Axis.Z).func_178787_e(center);
            VoxelShape rotated = Block.func_208617_a((double)v1.field_72450_a, (double)v1.field_72448_b, (double)v1.field_72449_c, (double)v2.field_72450_a, (double)v2.field_72448_b, (double)v2.field_72449_c);
            result.setValue((Object)VoxelShapes.func_197872_a((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    public static VoxelShape join(IBooleanFunction function, VoxelShape ... shapes) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            result = VoxelShapes.func_197878_a((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return result.func_197753_c();
    }

    public static VoxelShape or(VoxelShape ... shapes) {
        return VoxelShaper.join(IBooleanFunction.field_223244_o_, shapes);
    }
}

