/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.init;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.DatagenModLoader;
import xyz.apex.forge.apexcore.core.block.PlayerPlushieBlock;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.client.renderer.ApexCoreItemStackBlockEntityRenderer;
import xyz.apex.forge.apexcore.core.client.renderer.PlayerPlushieBlockEntityRenderer;
import xyz.apex.forge.apexcore.core.init.ACRegistry;
import xyz.apex.forge.apexcore.lib.block.BlockHelper;
import xyz.apex.forge.apexcore.lib.item.WearableBlockItem;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;
import xyz.apex.forge.utility.registrator.builder.BlockBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.entry.BlockEntry;
import xyz.apex.forge.utility.registrator.entry.ItemEntry;

public final class PlayerPlushie {
    private static final ACRegistry REGISTRY = ACRegistry.getRegistry();
    public static final BlockEntry<PlayerPlushieBlock> PLAYER_PLUSHIE_BLOCK = PlayerPlushie.playerPlushie();
    public static final ItemEntry<BlockItem> PLAYER_PLUSHIE_BLOCK_ITEM = ItemEntry.cast(PLAYER_PLUSHIE_BLOCK.getSibling(Item.class));
    public static final BlockEntityEntry<PlayerPlushieBlockEntity> PLAYER_PLUSHIE_BLOCK_ENTITY = BlockEntityEntry.cast(PLAYER_PLUSHIE_BLOCK.getSibling(TileEntityType.class));
    public static final String NBT_SUPPORTER_DATA = "SupporterData";
    private static final String NBT_PLAYER_ID = "UUID";
    private static final String NBT_PLAYER_ALIASES = "Aliases";
    private static final String NBT_SUPPORTER_LEVEL = "Level";
    private static final String NBT_USERNAME = "Username";

    static void bootstrap() {
    }

    private static BlockEntry<PlayerPlushieBlock> playerPlushie() {
        return (BlockEntry)((BlockBuilder)((BlockBuilder)REGISTRY.block("player_plushie", PlayerPlushieBlock::new).lang("Player Plushie").lang("en_gb", "Player Plushie").initialProperties(Material.field_151580_n).strength(0.8f).sound(SoundType.field_185854_g).noOcclusion().blockState((ctx, provider) -> provider.getVariantBuilder((Block)ctx.get()).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)provider.models().getBuilder(ctx.getName())).texture("particle", "minecraft:block/white_wool")).build())).loot((lootTables, block) -> lootTables.func_218507_a((Block)block, LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a(NBT_SUPPORTER_DATA, NBT_SUPPORTER_DATA)))))).isValidSpawn(BlockHelper::never).isRedstoneConductor(BlockHelper::never).isSuffocating(BlockHelper::never).isViewBlocking(BlockHelper::never).addRenderType(() -> RenderType::func_228643_e_).item((block, properties) -> new WearableBlockItem(block, properties, EquipmentSlotType.HEAD)).model((ctx, provider) -> {
            ModelFile.UncheckedModelFile builtInEntity = new ModelFile.UncheckedModelFile("minecraft:builtin/entity");
            ((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder(ctx.getName())).parent((ModelFile)builtInEntity)).transforms().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(75.0f, 45.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f, 0.375f, 0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(0.0f, 135.0f, 0.0f).translation(0.0f, 4.0f, 0.0f).scale(0.4f, 0.4f, 0.4f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 14.5f, 0.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.GROUND).rotation(0.0f, 0.0f, 0.0f).translation(0.0f, 3.0f, 0.0f).scale(0.25f, 0.25f, 0.25f).end().transform(ModelBuilder.Perspective.FIXED).rotation(-90.0f, 0.0f, 0.0f).translation(0.0f, 0.0f, -8.0f).scale(1.0f, 1.0f, 1.0f).end().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, -135.0f, 0.0f).translation(0.0f, 0.0f, 0.0f).scale(0.625f, 0.625f, 0.625f).end().end();
        }).itemGroup(() -> ItemGroup.field_78026_f).properties(properties -> properties.setISTER(() -> DatagenModLoader.isRunningDataGen() ? () -> null : ApexCoreItemStackBlockEntityRenderer::new)).build()).blockEntity(PlayerPlushieBlockEntity::new).renderer(() -> PlayerPlushieBlockEntityRenderer::new).build()).register();
    }

    public static List<ItemStack> getPlushieItems() {
        return SupporterManager.getSupporters().stream().map(PlayerPlushie::getPlushieItem).collect(Collectors.toList());
    }

    public static ItemStack getPlushieItem(SupporterManager.SupporterInfo info, int stackSize) {
        ItemStack stack = PLAYER_PLUSHIE_BLOCK.asItemStack(stackSize);
        CompoundNBT stackTag = stack.func_196082_o();
        CompoundNBT supporterTag = PlayerPlushie.writeSupporterInfoTag(info);
        stackTag.func_218657_a(NBT_SUPPORTER_DATA, (INBT)supporterTag);
        return stack;
    }

    public static ItemStack getPlushieItem(SupporterManager.SupporterInfo info) {
        return PlayerPlushie.getPlushieItem(info, 1);
    }

    @Nullable
    public static SupporterManager.SupporterInfo getSupporterInfo(ItemStack stack) {
        CompoundNBT stackTag = stack.func_77978_p();
        if (stackTag != null && stackTag.func_150297_b(NBT_SUPPORTER_DATA, 10)) {
            CompoundNBT supporterTag = stackTag.func_74775_l(NBT_SUPPORTER_DATA);
            return PlayerPlushie.getSupporterInfo(supporterTag);
        }
        return null;
    }

    @Nullable
    public static SupporterManager.SupporterInfo getSupporterInfo(CompoundNBT supporterTag) {
        Set<SupporterManager.SupporterInfo> supporters = SupporterManager.getSupporters();
        if (supporterTag.func_150297_b(NBT_PLAYER_ID, 11)) {
            UUID playerId = supporterTag.func_186857_a(NBT_PLAYER_ID);
            for (SupporterManager.SupporterInfo info : supporters) {
                if (!info.isFor(playerId)) continue;
                return info;
            }
        }
        if (supporterTag.func_150297_b(NBT_PLAYER_ALIASES, 9)) {
            ListNBT aliasesTag = supporterTag.func_150295_c(NBT_PLAYER_ALIASES, 11);
            for (INBT inbt : aliasesTag) {
                UUID playerId = NBTUtil.func_186860_b((INBT)inbt);
                for (SupporterManager.SupporterInfo info : supporters) {
                    if (!info.isFor(playerId)) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public static CompoundNBT writeSupporterInfoTag(SupporterManager.SupporterInfo info) {
        Set<UUID> aliases = info.getAliases();
        SupporterManager.SupporterLevel level = info.getLevel();
        CompoundNBT supporterTag = new CompoundNBT();
        supporterTag.func_186854_a(NBT_PLAYER_ID, info.getPlayerId());
        supporterTag.func_74778_a(NBT_SUPPORTER_LEVEL, level.func_176610_l());
        supporterTag.func_74778_a(NBT_USERNAME, info.getUsername());
        if (!aliases.isEmpty()) {
            ListNBT aliasesTag = new ListNBT();
            aliases.forEach(alias -> aliasesTag.add((Object)NBTUtil.func_240626_a_((UUID)alias)));
            supporterTag.func_218657_a(NBT_PLAYER_ALIASES, (INBT)aliasesTag);
        }
        return supporterTag;
    }
}

