/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import xyz.apex.forge.apexcore.core.block.entity.PlayerPlushieBlockEntity;
import xyz.apex.forge.apexcore.core.client.renderer.PlayerPlushieBlockEntityRenderer;
import xyz.apex.forge.apexcore.core.init.PlayerPlushie;
import xyz.apex.forge.apexcore.lib.support.SupporterManager;

public final class ApexCoreItemStackBlockEntityRenderer
extends ItemStackTileEntityRenderer {
    private final PlayerPlushieBlockEntityRenderer playerPlushieBlockEntityRenderer;
    private final Map<UUID, PlayerPlushieBlockEntity> playerPlushieBlockEntityMap = Maps.newHashMap();

    public ApexCoreItemStackBlockEntityRenderer() {
        this.playerPlushieBlockEntityRenderer = new PlayerPlushieBlockEntityRenderer(TileEntityRendererDispatcher.field_147556_a);
    }

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack pose, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        PlayerPlushieBlockEntity blockEntity;
        SupporterManager.SupporterInfo supporterInfo;
        float partialTick = Minecraft.func_71410_x().func_193989_ak();
        if (PlayerPlushie.PLAYER_PLUSHIE_BLOCK.isInStack(stack) && (supporterInfo = PlayerPlushie.getSupporterInfo(stack)) != null && (blockEntity = this.getPlayerPlushieBlockEntity(supporterInfo)) != null) {
            this.playerPlushieBlockEntityRenderer.renderLayers = false;
            this.playerPlushieBlockEntityRenderer.render(blockEntity, partialTick, pose, renderTypeBuffer, light, overlay);
            return;
        }
        super.func_239207_a_(stack, transformType, pose, renderTypeBuffer, light, overlay);
    }

    @Nullable
    private PlayerPlushieBlockEntity getPlayerPlushieBlockEntity(SupporterManager.SupporterInfo supporterInfo) {
        UUID playerId = supporterInfo.getPlayerId();
        if (this.playerPlushieBlockEntityMap.containsKey(playerId)) {
            return this.playerPlushieBlockEntityMap.get(playerId);
        }
        PlayerPlushieBlockEntity blockEntity = PlayerPlushie.PLAYER_PLUSHIE_BLOCK_ENTITY.createBlockEntity();
        if (blockEntity != null) {
            blockEntity.setSupporterInfo(supporterInfo);
            this.playerPlushieBlockEntityMap.put(playerId, blockEntity);
            return blockEntity;
        }
        return null;
    }
}

