/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.items;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.pocket.apis.PocketAPI;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.inventory.PocketComputerMenuProvider;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemPocketComputer
extends Item
implements IComputerItem,
IMedia,
IColouredItem {
    private static final String NBT_UPGRADE = "Upgrade";
    private static final String NBT_UPGRADE_INFO = "UpgradeInfo";
    public static final String NBT_LIGHT = "Light";
    private static final String NBT_ON = "On";
    private static final String NBT_INSTANCE = "Instanceid";
    private static final String NBT_SESSION = "SessionId";
    private final ComputerFamily family;

    public ItemPocketComputer(Item.Properties settings, ComputerFamily family) {
        super(settings);
        this.family = family;
    }

    public ItemStack create(int id, String label, int colour, IPocketUpgrade upgrade) {
        ItemStack result = new ItemStack((IItemProvider)this);
        if (id >= 0) {
            result.func_196082_o().func_74768_a("ComputerId", id);
        }
        if (label != null) {
            result.func_200302_a((ITextComponent)new StringTextComponent(label));
        }
        if (upgrade != null) {
            result.func_196082_o().func_74778_a(NBT_UPGRADE, upgrade.getUpgradeID().toString());
        }
        if (colour != -1) {
            result.func_196082_o().func_74768_a("Color", colour);
        }
        return result;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> stacks) {
        if (!this.func_194125_a(group)) {
            return;
        }
        stacks.add((Object)this.create(-1, null, -1, null));
        for (IPocketUpgrade upgrade : PocketUpgrades.getVanillaUpgrades()) {
            stacks.add((Object)this.create(-1, null, -1, upgrade));
        }
    }

    private boolean tick(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull Entity entity, @Nonnull PocketServerComputer computer) {
        boolean on;
        String label;
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        computer.setWorld((ServerWorld)world);
        computer.updateValues(entity, stack, upgrade);
        boolean changed = false;
        int id = computer.getID();
        if (id != this.getComputerID(stack)) {
            changed = true;
            ItemPocketComputer.setComputerID(stack, id);
        }
        if (!Objects.equal((Object)(label = computer.getLabel()), (Object)this.getLabel(stack))) {
            changed = true;
            this.setLabel(stack, label);
        }
        if ((on = computer.isOn()) != ItemPocketComputer.isMarkedOn(stack)) {
            changed = true;
            stack.func_196082_o().func_74757_a(NBT_ON, on);
        }
        if (upgrade != null) {
            upgrade.update(computer, computer.getPeripheral(ComputerSide.BACK));
        }
        return changed;
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, @Nonnull Entity entity, int slotNum, boolean selected) {
        if (world.field_72995_K) {
            return;
        }
        PlayerInventory inventory = entity instanceof PlayerEntity ? ((PlayerEntity)entity).field_71071_by : null;
        PocketServerComputer computer = this.createServerComputer((ServerWorld)world, entity, (IInventory)inventory, stack);
        computer.keepAlive();
        boolean changed = this.tick(stack, world, entity, computer);
        if (changed && inventory != null) {
            inventory.func_70296_d();
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        PocketServerComputer computer = ItemPocketComputer.getServerComputer(entity.field_70170_p.func_73046_m(), stack);
        if (computer != null && this.tick(stack, entity.field_70170_p, (Entity)entity, computer)) {
            entity.func_92058_a(stack.func_77946_l());
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            PocketServerComputer computer = this.createServerComputer((ServerWorld)world, (Entity)player, (IInventory)player.field_71071_by, stack);
            computer.turnOn();
            boolean stop = false;
            IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
            if (upgrade != null) {
                computer.updateValues((Entity)player, stack, upgrade);
                stop = upgrade.onRightClick(world, computer, computer.getPeripheral(ComputerSide.BACK));
            }
            if (!stop) {
                boolean isTypingOnly = hand == Hand.OFF_HAND;
                new ComputerContainerData(computer, stack).open(player, new PocketComputerMenuProvider(computer, stack, this, hand, isTypingOnly));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        String baseString = this.func_77667_c(stack);
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null) {
            return new TranslationTextComponent(baseString + ".upgraded", new Object[]{new TranslationTextComponent(upgrade.getUnlocalisedAdjective())});
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> list, ITooltipFlag flag) {
        int id;
        if ((flag.func_194127_a() || this.getLabel(stack) == null) && (id = this.getComputerID(stack)) >= 0) {
            list.add((ITextComponent)new TranslationTextComponent("gui.computercraft.tooltip.computer_id", new Object[]{id}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        IPocketUpgrade upgrade = ItemPocketComputer.getUpgrade(stack);
        if (upgrade != null && (mod = PocketUpgrades.getOwner(upgrade)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return super.getCreatorModId(stack);
    }

    @Nonnull
    public PocketServerComputer createServerComputer(ServerWorld world, Entity entity, @Nullable IInventory inventory, @Nonnull ItemStack stack) {
        if (world.field_72995_K) {
            throw new IllegalStateException("Cannot call createServerComputer on the client");
        }
        int sessionID = ItemPocketComputer.getSessionID(stack);
        ServerComputerRegistry registry = ServerContext.get(world.func_73046_m()).registry();
        PocketServerComputer computer = (PocketServerComputer)registry.get(sessionID, ItemPocketComputer.getInstanceID(stack));
        if (computer == null) {
            int computerID = this.getComputerID(stack);
            if (computerID < 0) {
                computerID = ComputerCraftAPI.createUniqueNumberedSaveDir((World)world, "computer");
                ItemPocketComputer.setComputerID(stack, computerID);
            }
            computer = new PocketServerComputer(world, this.getComputerID(stack), this.getLabel(stack), this.getFamily());
            ItemPocketComputer.setInstanceID(stack, computer.register());
            ItemPocketComputer.setSessionID(stack, registry.getSessionID());
            computer.updateValues(entity, stack, ItemPocketComputer.getUpgrade(stack));
            computer.addAPI(new PocketAPI(computer));
            if (ItemPocketComputer.isMarkedOn(stack) && entity instanceof PlayerEntity) {
                computer.turnOn();
            }
            if (inventory != null) {
                inventory.func_70296_d();
            }
        }
        computer.setWorld(world);
        return computer;
    }

    @Nullable
    public static PocketServerComputer getServerComputer(MinecraftServer server, @Nonnull ItemStack stack) {
        return (PocketServerComputer)ServerContext.get(server).registry().get(ItemPocketComputer.getSessionID(stack), ItemPocketComputer.getInstanceID(stack));
    }

    private static void setComputerID(@Nonnull ItemStack stack, int computerID) {
        stack.func_196082_o().func_74768_a("ComputerId", computerID);
    }

    @Override
    public String getLabel(@Nonnull ItemStack stack) {
        return IComputerItem.super.getLabel(stack);
    }

    @Override
    public ComputerFamily getFamily() {
        return this.family;
    }

    @Override
    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return PocketComputerItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, ItemPocketComputer.getUpgrade(stack));
    }

    @Override
    public boolean setLabel(@Nonnull ItemStack stack, String label) {
        if (label != null) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(label));
        } else {
            stack.func_135074_t();
        }
        return true;
    }

    @Override
    public IMount createDataMount(@Nonnull ItemStack stack, @Nonnull World world) {
        int id = this.getComputerID(stack);
        if (id >= 0) {
            return ComputerCraftAPI.createSaveDirMount(world, "computer/" + id, ComputerCraft.computerSpaceLimit);
        }
        return null;
    }

    public static int getInstanceID(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_INSTANCE) ? nbt.func_74762_e(NBT_INSTANCE) : -1;
    }

    private static void setInstanceID(@Nonnull ItemStack stack, int instanceID) {
        stack.func_196082_o().func_74768_a(NBT_INSTANCE, instanceID);
    }

    private static int getSessionID(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b(NBT_SESSION) ? nbt.func_74762_e(NBT_SESSION) : -1;
    }

    private static void setSessionID(@Nonnull ItemStack stack, int sessionID) {
        stack.func_196082_o().func_74768_a(NBT_SESSION, sessionID);
    }

    private static boolean isMarkedOn(@Nonnull ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(NBT_ON);
    }

    public static IPocketUpgrade getUpgrade(@Nonnull ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        return compound != null && compound.func_74764_b(NBT_UPGRADE) ? PocketUpgrades.get(compound.func_74779_i(NBT_UPGRADE)) : null;
    }

    public static void setUpgrade(@Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        CompoundNBT compound = stack.func_196082_o();
        if (upgrade == null) {
            compound.func_82580_o(NBT_UPGRADE);
        } else {
            compound.func_74778_a(NBT_UPGRADE, upgrade.getUpgradeID().toString());
        }
        compound.func_82580_o(NBT_UPGRADE_INFO);
    }

    public static CompoundNBT getUpgradeInfo(@Nonnull ItemStack stack) {
        return stack.func_190925_c(NBT_UPGRADE_INFO);
    }
}

