/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;

public class PrettyJsonWriter
extends JsonWriter {
    private static final boolean ENABLED = System.getProperty("cct.pretty-json") != null;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int MAX_WIDTH = 120;
    private final Writer out;
    private final Deque<Object> stack = new ArrayDeque<Object>();
    private static final String[] STRING_REPLACE = new String[128];

    public PrettyJsonWriter(Writer out) {
        super(out);
        this.out = out;
    }

    public static JsonWriter createWriter(Writer out) {
        return ENABLED ? new PrettyJsonWriter(out) : new JsonWriter(out);
    }

    public static void save(DirectoryCache cache, JsonElement json, Path path) throws IOException {
        StringWriter writer = new StringWriter();
        GSON.toJson(json, PrettyJsonWriter.createWriter(writer));
        String contents = writer.toString();
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)contents).toString();
        if (!Objects.equals(cache.func_208323_a(path), hash) || !Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                bufferedwriter.write(contents);
            }
        }
        cache.func_208316_a(path, hash);
    }

    private void pushValue(Object object) throws IOException {
        if (this.stack.isEmpty()) {
            PrettyJsonWriter.write(this.out, object, 120, 0);
            return;
        }
        Object head = this.stack.getLast();
        if (head instanceof DocList) {
            ((DocList)head).add(object);
        } else {
            this.stack.removeLast();
            ((DocList)this.stack.getLast()).add(new Pair((String)head, object));
        }
    }

    public JsonWriter beginArray() {
        this.stack.add(new DocList("[", "]"));
        return this;
    }

    public JsonWriter endArray() throws IOException {
        DocList list = (DocList)this.stack.removeLast();
        this.pushValue(list);
        return this;
    }

    public JsonWriter beginObject() {
        this.stack.add(new DocList("{", "}"));
        return this;
    }

    public JsonWriter endObject() throws IOException {
        return this.endArray();
    }

    public JsonWriter name(String name) throws IOException {
        this.stack.add(PrettyJsonWriter.escapeString(name));
        return this;
    }

    public JsonWriter jsonValue(String value) throws IOException {
        this.pushValue(value);
        return this;
    }

    public JsonWriter value(@Nullable String value) throws IOException {
        return value == null ? this.nullValue() : this.jsonValue(PrettyJsonWriter.escapeString(value));
    }

    public JsonWriter nullValue() throws IOException {
        if (!this.getSerializeNulls() && this.stack.peekLast() instanceof String) {
            this.stack.removeLast();
            return this;
        }
        return this.jsonValue("null");
    }

    public JsonWriter value(boolean value) throws IOException {
        return this.jsonValue(Boolean.toString(value));
    }

    public JsonWriter value(@Nullable Boolean value) throws IOException {
        return value == null ? this.nullValue() : this.jsonValue(Boolean.toString(value));
    }

    public JsonWriter value(double value) throws IOException {
        return this.jsonValue(Double.toString(value));
    }

    public JsonWriter value(long value) throws IOException {
        return this.jsonValue(Long.toString(value));
    }

    public JsonWriter value(@Nullable Number value) throws IOException {
        return value == null ? this.nullValue() : this.jsonValue(value.toString());
    }

    public void close() throws IOException {
        if (!this.stack.isEmpty()) {
            throw new IllegalArgumentException("Object is remaining on the stack");
        }
        this.out.close();
    }

    private static int width(Object object) {
        if (object instanceof String) {
            return ((String)object).length();
        }
        if (object instanceof DocList) {
            return ((DocList)object).width;
        }
        if (object instanceof Pair) {
            return ((Pair)object).width();
        }
        throw new IllegalArgumentException("Not a valid document");
    }

    private static int write(Writer writer, Object object, int space, int indent) throws IOException {
        if (object instanceof String) {
            String str = (String)object;
            writer.write(str);
            return space - str.length();
        }
        if (object instanceof DocList) {
            return ((DocList)object).write(writer, space, indent);
        }
        if (object instanceof Pair) {
            return ((Pair)object).write(writer, space, indent);
        }
        throw new IllegalArgumentException("Not a valid document");
    }

    private static String escapeString(String value) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            String replacement = null;
            if (c < STRING_REPLACE.length) {
                replacement = STRING_REPLACE[c];
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else if (c == '\u2029') {
                replacement = "\\u2029";
            }
            if (replacement == null) {
                builder.append(c);
                continue;
            }
            builder.append(replacement);
        }
        builder.append('\"');
        return builder.toString();
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            PrettyJsonWriter.STRING_REPLACE[i] = String.format("\\u%04x", i);
        }
        PrettyJsonWriter.STRING_REPLACE[34] = "\\\"";
        PrettyJsonWriter.STRING_REPLACE[92] = "\\\\";
        PrettyJsonWriter.STRING_REPLACE[9] = "\\t";
        PrettyJsonWriter.STRING_REPLACE[8] = "\\b";
        PrettyJsonWriter.STRING_REPLACE[10] = "\\n";
        PrettyJsonWriter.STRING_REPLACE[13] = "\\r";
        PrettyJsonWriter.STRING_REPLACE[12] = "\\f";
    }

    private static class DocList {
        final String prefix;
        final String suffix;
        final List<Object> contents = new ArrayList<Object>();
        int width;

        DocList(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.width = prefix.length() + suffix.length();
        }

        void add(Object value) {
            this.contents.add(value);
            this.width += PrettyJsonWriter.width(value) + (this.contents.isEmpty() ? 0 : 2);
        }

        int write(Writer writer, int space, int indent) throws IOException {
            writer.append(this.prefix);
            if (this.width <= space) {
                space -= this.prefix.length() + this.suffix.length();
                boolean comma = false;
                for (Object value : this.contents) {
                    if (comma) {
                        writer.append(", ");
                        space -= 2;
                    }
                    comma = true;
                    space = PrettyJsonWriter.write(writer, value, space, indent);
                }
            } else {
                String indentStr = Strings.repeat((String)" ", (int)indent);
                writer.append("\n  ").append(indentStr);
                boolean comma = false;
                for (Object value : this.contents) {
                    if (comma) {
                        writer.append(",\n  ").append(indentStr);
                    }
                    comma = true;
                    PrettyJsonWriter.write(writer, value, 120 - indent - 2, indent + 2);
                }
                writer.append("\n").append(indentStr);
            }
            writer.append(this.suffix);
            return space;
        }
    }

    private static final class Pair {
        final String key;
        final Object value;

        private Pair(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        int width() {
            return this.key.length() + 2 + PrettyJsonWriter.width(this.value);
        }

        int write(Writer out, int space, int indent) throws IOException {
            out.write(this.key);
            out.write(": ");
            return PrettyJsonWriter.write(out, this.value, space - this.key.length() - 2, indent);
        }
    }
}

