/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http.options;

import com.google.common.net.InetAddresses;
import dan200.computercraft.ComputerCraft;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

interface AddressPredicate {
    default public boolean matches(String domain) {
        return false;
    }

    default public boolean matches(InetAddress socketAddress) {
        return false;
    }

    public static final class PrivatePattern
    implements AddressPredicate {
        static final PrivatePattern INSTANCE = new PrivatePattern();
        private static final Set<InetAddress> additionalAddresses = Arrays.stream(new String[]{"100.100.100.200", "192.0.0.192"}).map(InetAddresses::forString).collect(Collectors.toSet());

        @Override
        public boolean matches(InetAddress socketAddress) {
            return socketAddress.isAnyLocalAddress() || socketAddress.isLoopbackAddress() || socketAddress.isLinkLocalAddress() || socketAddress.isSiteLocalAddress() || socketAddress.isMulticastAddress() || this.isUniqueLocalAddress(socketAddress) || additionalAddresses.contains(socketAddress);
        }

        private boolean isUniqueLocalAddress(InetAddress address) {
            return address instanceof Inet6Address && (address.getAddress()[0] & 0xFF) == 253;
        }
    }

    public static final class DomainPattern
    implements AddressPredicate {
        private final Pattern pattern;

        DomainPattern(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String domain) {
            return this.pattern.matcher(domain).matches();
        }

        @Override
        public boolean matches(InetAddress socketAddress) {
            return this.pattern.matcher(socketAddress.getHostAddress()).matches();
        }
    }

    public static final class HostRange
    implements AddressPredicate {
        private final byte[] min;
        private final byte[] max;

        HostRange(byte[] min, byte[] max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public boolean matches(InetAddress address) {
            byte[] entry = address.getAddress();
            if (entry.length != this.min.length) {
                return false;
            }
            for (int i = 0; i < entry.length; ++i) {
                int value = 0xFF & entry[i];
                if (value >= (0xFF & this.min[i]) && value <= (0xFF & this.max[i])) continue;
                return false;
            }
            return true;
        }

        public static HostRange parse(String addressStr, String prefixSizeStr) {
            InetAddress address;
            int prefixSize;
            try {
                prefixSize = Integer.parseInt(prefixSizeStr);
            }
            catch (NumberFormatException e) {
                ComputerCraft.log.error("Malformed http whitelist/blacklist entry '{}': Cannot extract size of CIDR mask from '{}'.", (Object)(addressStr + '/' + prefixSizeStr), (Object)prefixSizeStr);
                return null;
            }
            try {
                address = InetAddresses.forString((String)addressStr);
            }
            catch (IllegalArgumentException e) {
                ComputerCraft.log.error("Malformed http whitelist/blacklist entry '{}': Cannot extract IP address from '{}'.", (Object)(addressStr + '/' + prefixSizeStr), (Object)prefixSizeStr);
                return null;
            }
            byte[] minBytes = address.getAddress();
            byte[] maxBytes = address.getAddress();
            int size = prefixSize;
            for (int i = 0; i < minBytes.length; ++i) {
                if (size <= 0) {
                    int n = i;
                    minBytes[n] = (byte)(minBytes[n] & 0);
                    int n2 = i;
                    maxBytes[n2] = (byte)(maxBytes[n2] | 0xFF);
                } else if (size < 8) {
                    int n = i;
                    minBytes[n] = (byte)(minBytes[n] & 255 << 8 - size);
                    int n3 = i;
                    maxBytes[n3] = (byte)(maxBytes[n3] | ~(255 << 8 - size));
                }
                size -= 8;
            }
            return new HostRange(minBytes, maxBytes);
        }
    }
}

