/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft", value={Dist.CLIENT})
public final class MonitorHighlightRenderer {
    private MonitorHighlightRenderer() {
    }

    @SubscribeEvent
    public static void drawHighlight(DrawHighlightEvent.HighlightBlock event) {
        BlockPos pos;
        if (event.getInfo().func_216773_g().func_213453_ef()) {
            return;
        }
        World world = event.getInfo().func_216773_g().func_130014_f_();
        TileEntity tile = world.func_175625_s(pos = event.getTarget().func_216350_a());
        if (!(tile instanceof TileMonitor)) {
            return;
        }
        TileMonitor monitor = (TileMonitor)tile;
        event.setCanceled(true);
        EnumSet<Direction> faces = EnumSet.allOf(Direction.class);
        Direction front = monitor.getFront();
        faces.remove(front);
        if (monitor.getXIndex() != 0) {
            faces.remove(monitor.getRight().func_176734_d());
        }
        if (monitor.getXIndex() != monitor.getWidth() - 1) {
            faces.remove(monitor.getRight());
        }
        if (monitor.getYIndex() != 0) {
            faces.remove(monitor.getDown().func_176734_d());
        }
        if (monitor.getYIndex() != monitor.getHeight() - 1) {
            faces.remove(monitor.getDown());
        }
        MatrixStack transformStack = event.getMatrix();
        Vector3d cameraPos = event.getInfo().func_216785_c();
        transformStack.func_227860_a_();
        transformStack.func_227861_a_((double)pos.func_177958_n() - cameraPos.func_82615_a(), (double)pos.func_177956_o() - cameraPos.func_82617_b(), (double)pos.func_177952_p() - cameraPos.func_82616_c());
        IVertexBuilder buffer = event.getBuffers().getBuffer(RenderType.func_228659_m_());
        Matrix4f transform = transformStack.func_227866_c_().func_227870_a_();
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.WEST)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 0.0f, 0.0f, Direction.UP);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.WEST)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 0.0f, 1.0f, Direction.UP);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.EAST)) {
            MonitorHighlightRenderer.line(buffer, transform, 1.0f, 0.0f, 0.0f, Direction.UP);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.EAST)) {
            MonitorHighlightRenderer.line(buffer, transform, 1.0f, 0.0f, 1.0f, Direction.UP);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 0.0f, 0.0f, Direction.EAST);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 0.0f, 1.0f, Direction.EAST);
        }
        if (faces.contains(Direction.NORTH) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 1.0f, 0.0f, Direction.EAST);
        }
        if (faces.contains(Direction.SOUTH) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 1.0f, 1.0f, Direction.EAST);
        }
        if (faces.contains(Direction.WEST) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 0.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.EAST) || faces.contains(Direction.DOWN)) {
            MonitorHighlightRenderer.line(buffer, transform, 1.0f, 0.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.WEST) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, 0.0f, 1.0f, 0.0f, Direction.SOUTH);
        }
        if (faces.contains(Direction.EAST) || faces.contains(Direction.UP)) {
            MonitorHighlightRenderer.line(buffer, transform, 1.0f, 1.0f, 0.0f, Direction.SOUTH);
        }
        transformStack.func_227865_b_();
    }

    private static void line(IVertexBuilder buffer, Matrix4f transform, float x, float y, float z, Direction direction) {
        buffer.func_227888_a_(transform, x, y, z).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buffer.func_227888_a_(transform, x + (float)direction.func_82601_c(), y + (float)direction.func_96559_d(), z + (float)direction.func_82599_e()).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
    }
}

