/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ItemToast
implements IToast {
    public static final Object TRANSFER_NO_RESPONSE_TOKEN = new Object();
    private static final long DISPLAY_TIME = 7000L;
    private static final int MAX_LINE_SIZE = 200;
    private static final int IMAGE_SIZE = 16;
    private static final int LINE_SPACING = 10;
    private static final int MARGIN = 8;
    private final ItemStack stack;
    private final ITextComponent title;
    private final List<IReorderingProcessor> message;
    private final Object token;
    private final int width;
    private boolean isNew = true;
    private long firstDisplay;

    public ItemToast(Minecraft minecraft, ItemStack stack, ITextComponent title, ITextComponent message, Object token) {
        this.stack = stack;
        this.title = title;
        this.token = token;
        FontRenderer font = minecraft.field_71466_p;
        this.message = font.func_238425_b_((ITextProperties)message, 200);
        this.width = Math.max(200, this.message.stream().mapToInt(arg_0 -> ((FontRenderer)font).func_243245_a(arg_0)).max().orElse(200)) + 24 + 16;
    }

    public void showOrReplace(ToastGui toasts) {
        ItemToast existing = (ItemToast)toasts.func_192990_a(ItemToast.class, this.func_193652_b());
        if (existing != null) {
            existing.isNew = true;
        } else {
            toasts.func_192988_a((IToast)this);
        }
    }

    public int func_230445_a_() {
        return this.width;
    }

    public int func_238540_d_() {
        return 26 + this.message.size() * 10;
    }

    @Nonnull
    public Object func_193652_b() {
        return this.token;
    }

    @Nonnull
    public IToast.Visibility func_230444_a_(@Nonnull MatrixStack transform, @Nonnull ToastGui component, long time) {
        if (this.isNew) {
            this.firstDisplay = time;
            this.isNew = false;
        }
        component.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (this.width == 160 && this.message.size() <= 1) {
            component.func_238474_b_(transform, 0, 0, 0, 64, this.width, this.func_238540_d_());
        } else {
            int height = this.func_238540_d_();
            int bottom = Math.min(4, height - 28);
            ItemToast.renderBackgroundRow(transform, component, this.width, 0, 0, 28);
            for (int i = 28; i < height - bottom; i += 10) {
                ItemToast.renderBackgroundRow(transform, component, this.width, 16, i, Math.min(16, height - i - bottom));
            }
            ItemToast.renderBackgroundRow(transform, component, this.width, 32 - bottom, height - bottom, bottom);
        }
        int textX = 8;
        if (!this.stack.func_190926_b()) {
            textX += 24;
            component.func_192989_b().func_175599_af().func_239390_c_(this.stack, 8, 8 + this.func_238540_d_() / 2 - 16);
        }
        component.func_192989_b().field_71466_p.func_243248_b(transform, this.title, (float)textX, 8.0f, -11534256);
        for (int i = 0; i < this.message.size(); ++i) {
            component.func_192989_b().field_71466_p.func_238422_b_(transform, this.message.get(i), (float)textX, (float)(10 + (i + 1) * 10), -16777216);
        }
        return time - this.firstDisplay < 7000L ? IToast.Visibility.SHOW : IToast.Visibility.HIDE;
    }

    private static void renderBackgroundRow(MatrixStack transform, ToastGui component, int x, int u, int y, int height) {
        int leftOffset = 5;
        int rightOffset = Math.min(60, x - leftOffset);
        component.func_238474_b_(transform, 0, y, 0, 32 + u, leftOffset, height);
        for (int k = leftOffset; k < x - rightOffset; k += 64) {
            component.func_238474_b_(transform, k, y, 32, 32 + u, Math.min(64, x - k - rightOffset), height);
        }
        component.func_238474_b_(transform, x - rightOffset, y, 160 - rightOffset, 32 + u, rightOffset, height);
    }
}

