/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.common.ContainerHeldItem;
import dan200.computercraft.shared.media.items.ItemPrintout;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public class GuiPrintout
extends ContainerScreen<ContainerHeldItem> {
    private final boolean book;
    private final int pages;
    private final TextBuffer[] text;
    private final TextBuffer[] colours;
    private int page;

    public GuiPrintout(ContainerHeldItem container, PlayerInventory player, ITextComponent title) {
        super((Container)container, player, title);
        this.field_147000_g = 209;
        String[] text = ItemPrintout.getText(container.getStack());
        this.text = new TextBuffer[text.length];
        for (int i = 0; i < this.text.length; ++i) {
            this.text[i] = new TextBuffer(text[i]);
        }
        String[] colours = ItemPrintout.getColours(container.getStack());
        this.colours = new TextBuffer[colours.length];
        for (int i = 0; i < this.colours.length; ++i) {
            this.colours[i] = new TextBuffer(colours[i]);
        }
        this.page = 0;
        this.pages = Math.max(this.text.length / 21, 1);
        this.book = ((ItemPrintout)container.getStack().func_77973_b()).getType() == ItemPrintout.Type.BOOK;
    }

    public boolean func_231046_a_(int key, int scancode, int modifiers) {
        if (super.func_231046_a_(key, scancode, modifiers)) {
            return true;
        }
        if (key == 262) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (key == 263) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double x, double y, double delta) {
        if (super.func_231043_a_(x, y, delta)) {
            return true;
        }
        if (delta < 0.0) {
            if (this.page < this.pages - 1) {
                ++this.page;
            }
            return true;
        }
        if (delta > 0.0) {
            if (this.page > 0) {
                --this.page;
            }
            return true;
        }
        return false;
    }

    protected void func_230450_a_(@Nonnull MatrixStack transform, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        IRenderTypeBuffer.Impl renderer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        Matrix4f matrix = transform.func_227866_c_().func_227870_a_();
        PrintoutRenderer.drawBorder(matrix, (IRenderTypeBuffer)renderer, this.field_147003_i, this.field_147009_r, this.func_230927_p_(), this.page, this.pages, this.book, 0xF000F0);
        PrintoutRenderer.drawText(matrix, (IRenderTypeBuffer)renderer, this.field_147003_i + 13, this.field_147009_r + 11, 21 * this.page, 0xF000F0, this.text, this.colours);
        renderer.func_228461_a_();
    }

    public void func_230430_a_(@Nonnull MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230926_e_(this.func_230927_p_() - 1);
        this.func_230446_a_(stack);
        this.func_230926_e_(this.func_230927_p_() + 1);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(@Nonnull MatrixStack transform, int mouseX, int mouseY) {
    }
}

