/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.client;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;

public final class TransformedModel {
    private final IBakedModel model;
    private final TransformationMatrix matrix;

    public TransformedModel(@Nonnull IBakedModel model, @Nonnull TransformationMatrix matrix) {
        this.model = Objects.requireNonNull(model);
        this.matrix = Objects.requireNonNull(matrix);
    }

    public TransformedModel(@Nonnull IBakedModel model) {
        this.model = Objects.requireNonNull(model);
        this.matrix = TransformationMatrix.func_227983_a_();
    }

    public static TransformedModel of(@Nonnull ModelResourceLocation location) {
        ModelManager modelManager = Minecraft.func_71410_x().func_209506_al();
        return new TransformedModel(modelManager.func_174953_a(location));
    }

    public static TransformedModel of(@Nonnull ResourceLocation location) {
        ModelManager modelManager = Minecraft.func_71410_x().func_209506_al();
        return new TransformedModel(modelManager.getModel(location));
    }

    public static TransformedModel of(@Nonnull ItemStack item, @Nonnull TransformationMatrix transform) {
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(item);
        return new TransformedModel(model, transform);
    }

    @Nonnull
    public IBakedModel getModel() {
        return this.model;
    }

    @Nonnull
    public TransformationMatrix getMatrix() {
        return this.matrix;
    }
}

