/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaInteger;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.NonResumableException;
import cc.tweaked.internal.cobalt.OperationHelper;
import cc.tweaked.internal.cobalt.UnwindThrowable;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.function.LibFunction;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import cc.tweaked.internal.cobalt.function.RegisteredFunction;
import cc.tweaked.internal.cobalt.function.ResumableVarArgFunction;
import cc.tweaked.internal.cobalt.function.VarArgFunction;
import cc.tweaked.internal.cobalt.lib.LuaLibrary;

public class TableLib
implements LuaLibrary {
    private static final LuaValue N = LuaString.valueOf("n");

    @Override
    public LuaTable add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable();
        RegisteredFunction.bind(env, t, new RegisteredFunction[]{RegisteredFunction.of("getn", TableLib::getn), RegisteredFunction.of("maxn", TableLib::maxn)});
        LibFunction.bind(t, () -> new TableLibV(), new String[]{"remove", "concat", "insert", "pack"});
        LibFunction.bind(t, () -> new TableLibR(), new String[]{"sort", "foreach", "foreachi", "unpack"});
        env.rawset("table", (LuaValue)t);
        state.loadedPackages.rawset("table", (LuaValue)t);
        return t;
    }

    private static LuaValue getn(LuaState state, LuaValue arg) throws LuaError {
        return LuaInteger.valueOf(arg.checkTable().length());
    }

    private static LuaValue maxn(LuaState state, LuaValue arg) throws LuaError {
        return ValueFactory.valueOf(arg.checkTable().maxn());
    }

    private static LuaValue foreach(LuaState state, LuaTable table, LuaValue func, ForEachState res) throws LuaError, UnwindThrowable {
        block1: {
            Varargs n;
            LuaValue r;
            LuaValue k = res.k;
            do {
                n = table.next(k);
                res.k = k = n.first();
                if (k.isNil()) break block1;
            } while ((r = OperationHelper.call(state, func, k, n.arg(2))).isNil());
            return r;
        }
        return Constants.NIL;
    }

    private static LuaValue foreachi(LuaState state, LuaTable table, LuaValue func, ForEachIState res) throws LuaError, UnwindThrowable {
        LuaValue v;
        int k = res.k;
        while (!(v = table.rawget(res.k = ++k)).isNil()) {
            LuaValue r = OperationHelper.call(state, func, (LuaValue)ValueFactory.valueOf(k), v);
            if (r.isNil()) continue;
            return r;
        }
        return Constants.NIL;
    }

    private static void heapSort(LuaState state, LuaTable table, int count, LuaValue compare, SortState res, int sortState, int counter) throws LuaError, UnwindThrowable {
        switch (sortState) {
            case 0: {
                int start;
                try {
                    for (start = counter; start >= 0; --start) {
                        TableLib.normalSiftDown(state, table, start, count - 1, compare, res);
                    }
                }
                catch (UnwindThrowable e) {
                    res.sortState = 0;
                    res.counter = start - 1;
                    throw e;
                }
                counter = count - 1;
            }
            case 1: {
                int end = counter;
                try {
                    while (end > 0) {
                        table.swap(end + 1, 1);
                        TableLib.normalSiftDown(state, table, 0, --end, compare, res);
                    }
                    break;
                }
                catch (UnwindThrowable e) {
                    res.sortState = 1;
                    res.counter = end;
                    throw e;
                }
            }
        }
    }

    private static void normalSiftDown(LuaState state, LuaTable table, int root, int end, LuaValue compare, SortState res) throws LuaError, UnwindThrowable {
        int siftState = -1;
        int child = -1;
        try {
            while (root * 2 + 1 <= end) {
                siftState = 0;
                child = root * 2 + 1;
                if (child < end && table.compare(state, child + 1, child + 2, compare)) {
                    ++child;
                }
                siftState = 1;
                if (table.compare(state, root + 1, child + 1, compare)) {
                    table.swap(root + 1, child + 1);
                    root = child;
                    continue;
                }
                return;
            }
        }
        catch (UnwindThrowable e) {
            res.root = root;
            res.child = child;
            res.siftState = siftState;
            res.end = end;
            throw e;
        }
    }

    private static int stateSiftDown(LuaState state, LuaTable table, LuaValue compare, SortState res, boolean value) throws LuaError, UnwindThrowable {
        int siftState = res.siftState;
        int child = res.child;
        int root = res.root;
        switch (siftState) {
            case 0: {
                if (value) {
                    ++child;
                }
                try {
                    value = table.compare(state, root + 1, child + 1, compare);
                }
                catch (UnwindThrowable e) {
                    res.child = child;
                    res.siftState = 1;
                    throw e;
                }
            }
            case 1: {
                if (value) {
                    table.swap(root + 1, child + 1);
                    return child;
                }
                return -1;
            }
        }
        throw new IllegalStateException("No such state " + siftState);
    }

    private static final class SortState {
        final LuaTable table;
        final int count;
        final LuaValue compare;
        int sortState = 0;
        int counter = -1;
        int siftState = -1;
        int root;
        int child;
        int end;

        private SortState(LuaTable table, int count, LuaValue compare) {
            this.table = table;
            this.count = count;
            this.compare = compare;
        }
    }

    static final class ForEachIState {
        int k = 0;
        final LuaTable table;
        final LuaValue func;

        ForEachIState(LuaTable table, LuaValue func) {
            this.table = table;
            this.func = func;
        }
    }

    static final class UnpackState {
        private final LuaValue table;
        private final int start;
        private int index;
        private int end;
        private LuaValue[] values;

        UnpackState(LuaValue table, int start) {
            this.table = table;
            this.start = start;
        }

        static /* synthetic */ LuaValue[] access$602(UnpackState x0, LuaValue[] x1) {
            x0.values = x1;
            return x1;
        }
    }

    static final class ForEachState {
        public LuaValue k = Constants.NIL;
        public final LuaTable table;
        public final LuaValue func;

        ForEachState(LuaTable table, LuaValue func) {
            this.table = table;
            this.func = func;
        }
    }

    private static final class TableLibR
    extends ResumableVarArgFunction<Object> {
        private TableLibR() {
        }

        @Override
        protected Varargs invoke(LuaState state, DebugFrame di, Varargs args) throws LuaError, UnwindThrowable {
            switch (this.opcode) {
                case 0: {
                    LuaTable table = args.arg(1).checkTable();
                    LuaValue compare = args.isNoneOrNil(2) ? Constants.NIL : args.arg(2).checkFunction();
                    int n = table.length();
                    if (n > 1) {
                        SortState res = new SortState(table, n, compare);
                        di.state = res;
                        TableLib.heapSort(state, table, n, compare, res, 0, n / 2 - 1);
                    }
                    return Constants.NONE;
                }
                case 1: {
                    LuaTable table = args.arg(1).checkTable();
                    LuaFunction function = args.arg(2).checkFunction();
                    ForEachState res = new ForEachState(table, function);
                    di.state = res;
                    return TableLib.foreach(state, table, function, res);
                }
                case 2: {
                    LuaTable table = args.arg(1).checkTable();
                    LuaFunction function = args.arg(2).checkFunction();
                    ForEachIState res = new ForEachIState(table, function);
                    di.state = res;
                    return TableLib.foreachi(state, table, function, res);
                }
                case 3: {
                    LuaValue table = args.arg(1);
                    int start = args.arg(2).optInteger(1);
                    UnpackState res = new UnpackState(table, start);
                    di.state = res;
                    LuaValue endValue = args.arg(3);
                    int end = res.end = (endValue.isNil() ? OperationHelper.length(state, table) : endValue).checkInteger();
                    if (start > end) {
                        return Constants.NONE;
                    }
                    LuaValue[] values = UnpackState.access$602(res, new LuaValue[end - start + 1]);
                    for (int i = start; i <= end; ++i) {
                        res.index = i;
                        values[i - start] = OperationHelper.getTable(state, table, ValueFactory.valueOf(i));
                    }
                    return ValueFactory.varargsOf(values);
                }
            }
            return Constants.NONE;
        }

        @Override
        protected Varargs resumeThis(LuaState state, Object object, Varargs value) throws LuaError, UnwindThrowable {
            switch (this.opcode) {
                case 0: {
                    SortState res = (SortState)object;
                    LuaTable table = res.table;
                    LuaValue compare = res.compare;
                    int count = res.count;
                    if (res.siftState != -1) {
                        int root = TableLib.stateSiftDown(state, table, compare, res, value.first().toBoolean());
                        res.siftState = -1;
                        if (root != -1) {
                            TableLib.normalSiftDown(state, table, root, res.end, compare, res);
                        }
                    }
                    TableLib.heapSort(state, table, count, compare, res, res.sortState, res.counter);
                    return Constants.NONE;
                }
                case 1: {
                    ForEachState res = (ForEachState)object;
                    return TableLib.foreach(state, res.table, res.func, res);
                }
                case 2: {
                    ForEachIState res = (ForEachIState)object;
                    return TableLib.foreachi(state, res.table, res.func, res);
                }
                case 3: {
                    UnpackState res = (UnpackState)object;
                    int start = res.start;
                    LuaValue table = res.table;
                    int end = res.end;
                    LuaValue[] values = res.values;
                    if (values == null) {
                        end = res.end = value.first().checkInteger();
                        if (start > end) {
                            return Constants.NONE;
                        }
                        values = UnpackState.access$602(res, new LuaValue[end - start + 1]);
                        res.index = start;
                    } else {
                        values[((UnpackState)res).index - start] = value.first();
                        res.index++;
                    }
                    for (int i = res.index; i <= end; ++i) {
                        res.index = i;
                        values[i - start] = OperationHelper.getTable(state, table, ValueFactory.valueOf(i));
                    }
                    return ValueFactory.varargsOf(values);
                }
            }
            throw new NonResumableException("Cannot resume " + this.debugName());
        }
    }

    private static final class TableLibV
    extends VarArgFunction {
        private TableLibV() {
        }

        @Override
        public Varargs invoke(LuaState state, Varargs args) throws LuaError {
            switch (this.opcode) {
                case 0: {
                    LuaTable table = args.arg(1).checkTable();
                    int pos = args.count() > 1 ? args.arg(2).checkInteger() : 0;
                    return table.remove(pos);
                }
                case 1: {
                    LuaTable table = args.arg(1).checkTable();
                    return table.concat(args.arg(2).optLuaString(Constants.EMPTYSTRING), args.arg(3).optInteger(1), args.exists(4) ? args.arg(4).checkInteger() : table.length());
                }
                case 2: {
                    LuaTable table = args.arg(1).checkTable();
                    int pos = args.count() > 2 ? args.arg(2).checkInteger() : 0;
                    LuaValue value = args.arg(args.count() > 2 ? 3 : 2);
                    table.insert(pos, value);
                    return Constants.NONE;
                }
                case 3: {
                    int count = args.count();
                    LuaTable table = new LuaTable(count, 1);
                    for (int i = 1; i <= count; ++i) {
                        table.rawset(i, args.arg(i));
                    }
                    table.rawset(N, (LuaValue)ValueFactory.valueOf(count));
                    return table;
                }
            }
            return Constants.NONE;
        }
    }
}

