/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.util;

import immersive_paintings.Config;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.util.TriConsumer;

public class Utils {
    public static double cosNoise(double time) {
        return Utils.cosNoise(time, 5);
    }

    public static double cosNoise(double time, int layers) {
        double value = 0.0;
        for (int i = 0; i < layers; ++i) {
            value += Math.cos(time);
            time *= 1.7;
        }
        return value;
    }

    public static String lastSplit(String string, String sep) {
        return string.substring(string.lastIndexOf(sep) + 1);
    }

    public static String firstSplit(String string, String sep) {
        int i = string.lastIndexOf(sep);
        if (i < 0) {
            return string;
        }
        return string.substring(0, i);
    }

    public static String identifierToTranslation(ResourceLocation identifier) {
        return Utils.firstSplit(Utils.lastSplit(identifier.func_110623_a(), "/"), ".");
    }

    public static void processByteArrayInChunks(byte[] is, TriConsumer<byte[], Integer, Integer> consumer) {
        int splits = (int)Math.ceil((double)is.length / (double)Config.getInstance().packetSize);
        int split = 0;
        for (int i = 0; i < is.length; i += Config.getInstance().packetSize) {
            byte[] ints = Arrays.copyOfRange(is, i, Math.min(is.length, i + Config.getInstance().packetSize));
            consumer.accept((Object)ints, (Object)split, (Object)splits);
            ++split;
        }
    }

    public static String escapeString(String string) {
        return string.toLowerCase(Locale.ROOT).replaceAll("[^a-z\\d_.-]", "");
    }
}

