/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.util;

import immersive_paintings.resources.ByteImage;

public class ImageManipulations {
    public static int scanForPixelArtMultiple(ByteImage image) {
        int[] hist = new int[64];
        for (int y = 0; y < image.getHeight(); y += 7) {
            int l = 0;
            int lastColor = 0;
            for (int x = 0; x < image.getWidth(); ++x) {
                int color = image.getARGB(x, y);
                if (x == 0 || lastColor == color) {
                    ++l;
                } else {
                    if (l < hist.length) {
                        int n = l;
                        hist[n] = hist[n] + 1;
                    }
                    l = 1;
                }
                lastColor = color;
            }
        }
        int bestScore = 0;
        int best = 1;
        for (int i = 1; i < hist.length; ++i) {
            if (hist[i] <= bestScore) continue;
            bestScore = hist[i];
            best = i;
        }
        return best;
    }

    public static void resize(ByteImage image, ByteImage source, double zoom, int ox, int oy) {
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int red = 0;
                int green = 0;
                int blue = 0;
                int samples = 0;
                int px = Math.max(0, (int)((double)ox + zoom * (double)x));
                while ((double)px < Math.min((double)(source.getWidth() - 1), (double)ox + zoom * (double)(x + 1))) {
                    int py = Math.max(0, (int)((double)oy + zoom * (double)y));
                    while ((double)py < Math.min((double)(source.getHeight() - 1), (double)oy + zoom * (double)(y + 1))) {
                        int index = source.getIndex(px, py);
                        byte[] bytes = source.getBytes();
                        red += bytes[index] & 0xFF;
                        green += bytes[index + 1] & 0xFF;
                        blue += bytes[index + 2] & 0xFF;
                        ++samples;
                        ++py;
                    }
                    ++px;
                }
                if (samples > 0) {
                    red /= samples;
                    green /= samples;
                    blue /= samples;
                }
                image.setPixel(x, y, red, green, blue);
            }
        }
    }

    public static void dither(ByteImage image, double dither) {
        float[] hsv = new float[3];
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.getHSV(hsv, x, y);
                for (int i = 1; i < 3; ++i) {
                    hsv[i] = x % 2 == y % 2 ? (float)Math.min(1.0, (double)hsv[i] + dither * 0.5) : (float)Math.max(0.0, (double)hsv[i] - dither * 0.5);
                }
                image.setHSV(x, y, hsv);
            }
        }
    }

    public static void reduceColors(ByteImage image, int bins) {
        float[] hsv = new float[3];
        float[][] hist = new float[3][256];
        boolean EXCLUDE_HUE = true;
        int base = image.getWidth() * image.getHeight() / 255;
        for (int channel = 1; channel < 3; ++channel) {
            for (int x = 0; x < 256; ++x) {
                hist[channel][x] = base;
            }
        }
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.getHSV(hsv, x, y);
                for (int i = 0; i < 3; ++i) {
                    float[] fArray = hist[i];
                    int n = ImageManipulations.toByte(hsv[i]);
                    fArray[n] = fArray[n] + 1.0f;
                }
            }
        }
        int binSize = image.getWidth() * image.getHeight() / bins + base * 255 / bins;
        float[][] lookup = new float[3][256];
        for (int channel = 1; channel < 3; ++channel) {
            int start = 0;
            int sum = 0;
            for (int bin = 0; bin < bins; ++bin) {
                int end;
                int avg = 0;
                for (end = start; (bin == bins - 1 || sum <= binSize) && end < 255; ++end) {
                    float v = hist[channel][end];
                    sum = (int)((float)sum + v);
                    avg = (int)((float)avg + (float)end * v);
                }
                if (start != end) {
                    for (int b = start; b < end + 1; ++b) {
                        lookup[channel][b] = (float)avg / (float)sum / 255.0f;
                    }
                }
                start = end;
                sum -= binSize;
            }
        }
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.getHSV(hsv, x, y);
                for (int channel = 1; channel < 3; ++channel) {
                    hsv[channel] = lookup[channel][ImageManipulations.toByte(hsv[channel])];
                }
                image.setHSV(x, y, hsv);
            }
        }
    }

    private static int toByte(float v) {
        return Math.min(255, Math.max(0, (int)(v * 255.0f)));
    }
}

