/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.Config;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.ImageManipulations;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.commons.io.IOUtils;

public class ServerPaintingManager {
    public static MinecraftServer server;
    private static Map<ResourceLocation, Painting> datapackPaintings;

    public static CustomServerPaintings get() {
        return (CustomServerPaintings)server.func_241755_D_().func_217481_x().func_215752_a(() -> new CustomServerPaintings("immersive_paintings"), "immersive_paintings");
    }

    public static Map<ResourceLocation, Painting> getDatapackPaintings() {
        return datapackPaintings;
    }

    public static void setDatapackPaintings(Map<ResourceLocation, Painting> datapackPaintings) {
        ServerPaintingManager.datapackPaintings = datapackPaintings;
    }

    public static Path getPaintingPath(ResourceLocation identifier) {
        return Paths.get("immersive_paintings", identifier.toString().replace(":", "_") + ".png");
    }

    public static void registerPainting(ResourceLocation identifier, Painting painting) {
        Painting.Texture texture = painting.getTexture(Painting.Type.FULL);
        if (texture.image != null) {
            Path path = ServerPaintingManager.getPaintingPath(identifier);
            new File(path.getParent().toString()).mkdirs();
            texture.image.write(path.toFile());
        }
        ServerPaintingManager.get().getCustomServerPaintings().put(identifier, painting);
        ServerPaintingManager.get().func_76186_a(true);
    }

    public static void deregisterPainting(ResourceLocation identifier) {
        ServerPaintingManager.get().getCustomServerPaintings().remove(identifier);
        ServerPaintingManager.get().func_76186_a(true);
        ServerPaintingManager.getPaintingPath(identifier).toFile().delete();
    }

    public static Painting getPainting(ResourceLocation i) {
        if (datapackPaintings.containsKey(i)) {
            return datapackPaintings.get(i);
        }
        return ServerPaintingManager.get().customServerPaintings.getOrDefault(i, Painting.DEFAULT);
    }

    public static Optional<ByteImage> getImage(ResourceLocation i, Painting.Type type) {
        Optional<byte[]> data = ServerPaintingManager.getImageData(i, type);
        if (data.isPresent()) {
            try {
                return Optional.of(ByteImage.read(data.get()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<byte[]> getImageData(ResourceLocation i, Painting.Type type) {
        Painting painting = ServerPaintingManager.getPainting(i);
        Painting.Texture texture = painting.getTexture(type);
        byte[] data = null;
        if (type == Painting.Type.FULL) {
            if (texture.image == null) {
                try {
                    if (texture.resource != null) {
                        data = texture.getResource();
                        return Optional.ofNullable(data);
                    }
                    if (!ServerPaintingManager.get().customServerPaintings.containsKey(i)) return Optional.ofNullable(data);
                    try (FileInputStream stream = new FileInputStream(ServerPaintingManager.getPaintingPath(i).toString());){
                        data = IOUtils.toByteArray((InputStream)stream);
                        return Optional.ofNullable(data);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                data = texture.image.encode();
            }
            return Optional.ofNullable(data);
        } else {
            Optional<byte[]> imageData = Cache.getData(texture);
            if (imageData.isPresent()) {
                data = imageData.get();
                return Optional.ofNullable(data);
            } else {
                int h;
                int w;
                Optional<ByteImage> optionalByteImage = ServerPaintingManager.getImage(i, Painting.Type.FULL);
                if (!optionalByteImage.isPresent()) return Optional.ofNullable(data);
                ByteImage image = optionalByteImage.get();
                if (type == Painting.Type.THUMBNAIL) {
                    float zoom = Math.min((float)Config.getInstance().thumbnailSize / (float)image.getWidth(), (float)Config.getInstance().thumbnailSize / (float)image.getHeight());
                    if (zoom >= 1.0f) {
                        return ServerPaintingManager.getImageData(i, Painting.Type.FULL);
                    }
                    w = (int)((float)image.getWidth() * zoom);
                    h = (int)((float)image.getHeight() * zoom);
                } else if (type == Painting.Type.HALF) {
                    w = image.getWidth() / 2;
                    h = image.getHeight() / 2;
                } else if (type == Painting.Type.QUARTER) {
                    w = image.getWidth() / 4;
                    h = image.getHeight() / 4;
                } else {
                    w = image.getWidth() / 8;
                    h = image.getHeight() / 8;
                }
                ByteImage target = new ByteImage(w, h);
                ImageManipulations.resize(target, image, (double)image.getWidth() / (double)w, 0, 0);
                texture.image = target;
                data = texture.image.encode();
                Cache.set(texture, data);
            }
        }
        return Optional.ofNullable(data);
    }

    static {
        datapackPaintings = new HashMap<ResourceLocation, Painting>();
    }

    public static class CustomServerPaintings
    extends WorldSavedData {
        final Map<ResourceLocation, Painting> customServerPaintings = new HashMap<ResourceLocation, Painting>();

        public CustomServerPaintings(String key) {
            super(key);
        }

        public void func_76184_a(CompoundNBT nbt) {
            for (String key : nbt.func_150296_c()) {
                this.customServerPaintings.put(new ResourceLocation(key), Painting.fromNbt(nbt.func_74775_l(key)));
            }
        }

        public CompoundNBT func_189551_b(CompoundNBT nbt) {
            CompoundNBT c = new CompoundNBT();
            for (Map.Entry<ResourceLocation, Painting> entry : this.customServerPaintings.entrySet()) {
                c.func_218657_a(entry.getKey().toString(), (INBT)entry.getValue().toNbt());
            }
            return c;
        }

        public Map<ResourceLocation, Painting> getCustomServerPaintings() {
            return this.customServerPaintings;
        }
    }
}

