/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaintingsLoader
extends ReloadListener<Map<ResourceLocation, Painting>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private final Gson gson = new GsonBuilder().create();
    final String dataType = "paintings";

    protected Map<ResourceLocation, Painting> prepare(IResourceManager manager, IProfiler profiler) {
        HashMap map = Maps.newHashMap();
        int dataTypeLength = "paintings".length() + 1;
        for (ResourceLocation identifier : manager.func_199003_a("paintings", path -> path.endsWith(".png"))) {
            String string = identifier.func_110623_a();
            ResourceLocation imageIdentifier = new ResourceLocation(identifier.func_110624_b(), string.substring(dataTypeLength, string.length() - FILE_SUFFIX_LENGTH));
            try {
                Painting painting;
                ResourceLocation jsonIdentifier = new ResourceLocation(identifier.func_110624_b(), string.replace(".png", ".json"));
                String hash = identifier.toString().replaceAll("[^a-zA-Z\\d]", "");
                try {
                    InputStream inputStream = manager.func_199002_a(jsonIdentifier).func_199027_b();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                    JsonObject jsonElement = Objects.requireNonNull((JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class)).getAsJsonObject();
                    int width = JSONUtils.func_151208_a((JsonObject)jsonElement, (String)"width", (int)1);
                    int height = JSONUtils.func_151208_a((JsonObject)jsonElement, (String)"height", (int)1);
                    int resolution = JSONUtils.func_151208_a((JsonObject)jsonElement, (String)"resolution", (int)32);
                    String name = JSONUtils.func_151219_a((JsonObject)jsonElement, (String)"name", (String)"unknown");
                    String author = JSONUtils.func_151219_a((JsonObject)jsonElement, (String)"author", (String)"unknown");
                    painting = new Painting(null, width, height, resolution, name, author, true, false, hash);
                }
                catch (IOException ignored) {
                    painting = new Painting(null, 1, 1, 32, "unknown", "unknown", true, false, hash);
                }
                painting.texture.resource = manager.func_199002_a(identifier);
                map.put(identifier, painting);
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't load painting {} from {} ({})", (Object)imageIdentifier, (Object)identifier, (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, Painting> prepared, IResourceManager manager, IProfiler profiler) {
        ServerPaintingManager.setDatapackPaintings(prepared);
    }
}

