/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.resources.ByteImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class Painting {
    public int width;
    public int height;
    public final int resolution;
    public final String name;
    public final String author;
    public final boolean datapack;
    public final boolean hidden;
    public final Texture texture;
    public final Texture half;
    public final Texture quarter;
    public final Texture eighth;
    public final Texture thumbnail;
    public static final Painting DEFAULT = new Painting(new ByteImage(16, 16), 16);

    public Painting(@Nullable ByteImage image, int width, int height, int resolution, boolean hidden) {
        this(image, width, height, resolution, "", "", false, hidden, UUID.randomUUID().toString());
    }

    public Painting(@Nullable ByteImage image, int width, int height, int resolution, String name, String author, boolean datapack, boolean hidden, String hash) {
        this.texture = new Texture(image, hash, Type.FULL);
        int res = Math.max(width, height) * resolution;
        Type halfType = res / 2 < Config.getInstance().lodResolutionMinimum ? Type.FULL : Type.HALF;
        this.half = new Texture(null, hash + "_half", halfType);
        Type quarterType = res / 4 < Config.getInstance().lodResolutionMinimum ? halfType : Type.QUARTER;
        this.quarter = new Texture(null, hash + "_quarter", quarterType);
        Type eighthType = res / 8 < Config.getInstance().lodResolutionMinimum ? quarterType : Type.EIGHTH;
        this.eighth = new Texture(null, hash + "_eighth", eighthType);
        Type thumbnailType = res < Config.getInstance().thumbnailSize ? Type.FULL : Type.THUMBNAIL;
        this.thumbnail = new Texture(null, hash + "_thumbnail", thumbnailType);
        this.width = width;
        this.height = height;
        this.resolution = resolution;
        this.name = name;
        this.author = author;
        this.datapack = datapack;
        this.hidden = hidden;
    }

    public Painting(ByteImage image, int resolution) {
        this(image, image.getWidth() / resolution, image.getHeight() / resolution, resolution, "", "", false, false, UUID.randomUUID().toString());
    }

    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("width", this.width);
        nbt.func_74768_a("height", this.height);
        nbt.func_74768_a("resolution", this.resolution);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("author", this.author);
        nbt.func_74757_a("datapack", this.datapack);
        nbt.func_74757_a("hidden", this.hidden);
        nbt.func_74778_a("hash", this.texture.hash);
        return nbt;
    }

    public static Painting fromNbt(CompoundNBT nbt) {
        int width = nbt.func_74762_e("width");
        int height = nbt.func_74762_e("height");
        int resolution = nbt.func_74762_e("resolution");
        String name = nbt.func_74779_i("name");
        String author = nbt.func_74779_i("author");
        boolean datapack = nbt.func_74767_n("datapack");
        boolean hidden = nbt.func_74767_n("hidden");
        String hash = nbt.func_74779_i("hash");
        return new Painting(null, width, height, resolution, name, author, datapack, hidden, hash);
    }

    public Texture getTexture(Type type) {
        switch (type) {
            case FULL: {
                return this.texture;
            }
            case HALF: {
                return this.half;
            }
            case QUARTER: {
                return this.quarter;
            }
            case EIGHTH: {
                return this.eighth;
            }
            case THUMBNAIL: {
                return this.thumbnail;
            }
        }
        return this.thumbnail;
    }

    public static class Texture {
        public ByteImage image;
        public boolean requested = false;
        public ResourceLocation textureIdentifier = Main.locate("textures/block/frame/canvas.png");
        public IResource resource;
        public final String hash;
        public final Type link;
        private byte[] cache;

        public Texture(ByteImage image, String hash, Type link) {
            this.image = image;
            this.hash = hash;
            this.link = link;
        }

        public byte[] getResource() {
            if (this.cache == null) {
                try (InputStream stream = this.resource.func_199027_b();){
                    this.cache = IOUtils.toByteArray((InputStream)stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.cache;
        }
    }

    public static enum Type {
        FULL,
        HALF,
        QUARTER,
        EIGHTH,
        THUMBNAIL;

    }
}

