/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.client.ClientUtils;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.c2s.ImageRequest;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.Painting;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;

public class ClientPaintingManager {
    static final Map<ResourceLocation, Painting> paintings = new HashMap<ResourceLocation, Painting>();

    public static Map<ResourceLocation, Painting> getPaintings() {
        return paintings;
    }

    public static Painting getPainting(ResourceLocation identifier) {
        return paintings.getOrDefault(identifier, Painting.DEFAULT);
    }

    public static Painting.Texture getPaintingTexture(ResourceLocation identifier, Painting.Type type) {
        if (paintings.containsKey(identifier)) {
            Painting painting = paintings.get(identifier);
            Painting.Texture textureOriginal = painting.getTexture(type);
            Painting.Texture texture = painting.getTexture(textureOriginal.link);
            if (texture.image == null && !texture.requested) {
                texture.requested = true;
                Optional<ByteImage> image = Cache.get(texture);
                if (image.isPresent()) {
                    texture.image = image.get();
                    ClientPaintingManager.registerImage(texture);
                } else {
                    NetworkHandler.sendToServer(new ImageRequest(identifier, textureOriginal.link));
                }
            }
            if (texture.image == null) {
                for (Painting.Type t : Painting.Type.values()) {
                    Painting.Texture temporaryTexture = painting.getTexture(t);
                    if (temporaryTexture.image == null) continue;
                    return temporaryTexture;
                }
            }
            return texture;
        }
        return Painting.DEFAULT.texture;
    }

    public static void registerImage(Painting.Texture texture) {
        NativeImage nativeImage = ClientUtils.byteImageToNativeImage(texture.image);
        texture.textureIdentifier = Minecraft.func_71410_x().func_110434_K().func_110578_a("immersive_painting/" + texture.hash, new DynamicTexture(nativeImage));
    }
}

