/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.resources;

import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Painting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class Cache {
    private static File getFile(String key) {
        return new File("./immersive_paintings_cache/" + key + ".png");
    }

    public static Optional<ByteImage> get(Painting.Texture texture) {
        Optional<byte[]> data = Cache.getData(texture);
        if (data.isPresent()) {
            try {
                return Optional.of(ByteImage.read(data.get()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static Optional<byte[]> getData(Painting.Texture texture) {
        Optional<byte[]> optional;
        File file = Cache.getFile(texture.hash);
        if (!file.exists()) {
            return Optional.empty();
        }
        FileInputStream stream = new FileInputStream(file.getPath());
        try {
            optional = Optional.of(IOUtils.toByteArray((InputStream)stream));
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return Optional.empty();
            }
        }
        stream.close();
        return optional;
    }

    public static void set(Painting.Texture texture) {
        if (texture.image != null) {
            File file = Cache.getFile(texture.hash);
            file.getParentFile().mkdirs();
            texture.image.write(file);
        }
    }

    public static void set(Painting.Texture texture, byte[] data) {
        File file = Cache.getFile(texture.hash);
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            outputStream.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

