/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class PaintingListMessage
extends Message {
    private final Map<String, CompoundNBT> paintings = new HashMap<String, CompoundNBT>();
    private final boolean clear;
    private final boolean showOtherPlayersPaintings;

    public PaintingListMessage() {
        for (Map.Entry<ResourceLocation, Painting> entry : ServerPaintingManager.getDatapackPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), entry.getValue().toNbt());
        }
        for (Map.Entry<ResourceLocation, Painting> entry : ServerPaintingManager.get().getCustomServerPaintings().entrySet()) {
            this.paintings.put(entry.getKey().toString(), entry.getValue().toNbt());
        }
        this.showOtherPlayersPaintings = Config.getInstance().showOtherPlayersPaintings;
        this.clear = true;
    }

    @Override
    public void encode(PacketBuffer b) {
        b.writeInt(this.paintings.size());
        for (Map.Entry<String, CompoundNBT> entry : this.paintings.entrySet()) {
            b.func_180714_a(entry.getKey());
            b.func_150786_a(entry.getValue());
        }
        b.writeBoolean(this.clear);
        b.writeBoolean(this.showOtherPlayersPaintings);
    }

    public PaintingListMessage(PacketBuffer b) {
        int size = b.readInt();
        for (int i = 0; i < size; ++i) {
            String key = b.func_218666_n();
            CompoundNBT value = b.func_150793_b();
            this.paintings.put(key, value);
        }
        this.clear = b.readBoolean();
        this.showOtherPlayersPaintings = b.readBoolean();
    }

    public PaintingListMessage(ResourceLocation identifier, Painting painting) {
        this.paintings.put(identifier.toString(), painting == null ? null : painting.toNbt());
        this.showOtherPlayersPaintings = Config.getInstance().showOtherPlayersPaintings;
        this.clear = false;
    }

    @Override
    public void receive(PlayerEntity e) {
        Main.networkManager.handlePaintingListResponse(this);
    }

    public Map<ResourceLocation, Painting> getPaintings() {
        HashMap<ResourceLocation, Painting> paintings = new HashMap<ResourceLocation, Painting>();
        for (Map.Entry<String, CompoundNBT> entry : this.paintings.entrySet()) {
            ResourceLocation identifier = new ResourceLocation(entry.getKey());
            if (entry.getValue() == null) {
                paintings.put(identifier, null);
                continue;
            }
            paintings.put(identifier, Painting.fromNbt(entry.getValue()));
        }
        return paintings;
    }

    public boolean shouldClear() {
        return this.clear;
    }

    public boolean shouldShowOtherPlayersPaintings() {
        return this.showOtherPlayersPaintings;
    }
}

