/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.s2c;

import immersive_paintings.network.SegmentedPaintingMessage;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Cache;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ImageResponse
extends SegmentedPaintingMessage {
    private final String identifier;
    private final Painting.Type type;

    public ImageResponse(ResourceLocation identifier, Painting.Type type, byte[] data, int segment, int totalSegments) {
        super(data, segment, totalSegments);
        this.identifier = identifier.toString();
        this.type = type;
    }

    public ImageResponse(PacketBuffer b) {
        super(b);
        this.identifier = b.func_218666_n();
        this.type = (Painting.Type)b.func_179257_a(Painting.Type.class);
    }

    @Override
    protected String getIdentifier(PlayerEntity e) {
        return this.identifier + this.type.name();
    }

    @Override
    protected void process(PlayerEntity e, ByteImage image) {
        Painting painting = ClientPaintingManager.getPaintings().get(new ResourceLocation(this.identifier));
        Painting.Texture texture = painting.getTexture(this.type);
        texture.image = image;
        ClientPaintingManager.registerImage(texture);
        Cache.set(texture);
    }

    @Override
    public void encode(PacketBuffer b) {
        super.encode(b);
        b.func_180714_a(this.identifier);
        b.func_179249_a((Enum)this.type);
    }
}

