/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.c2s;

import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.network.s2c.RegisterPaintingResponse;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import immersive_paintings.util.Utils;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class RegisterPaintingRequest
extends Message {
    private final String name;
    private final CompoundNBT painting;

    public RegisterPaintingRequest(String name, Painting painting) {
        this.name = name;
        this.painting = painting.toNbt();
    }

    public RegisterPaintingRequest(PacketBuffer b) {
        this.name = b.func_218666_n();
        this.painting = b.func_150793_b();
    }

    @Override
    public void encode(PacketBuffer b) {
        b.func_180714_a(this.name);
        b.func_150786_a(this.painting);
    }

    @Override
    public void receive(PlayerEntity e) {
        ByteImage image = UploadPaintingRequest.uploadedImages.get(e.func_189512_bd());
        if (image.getWidth() > Config.getInstance().maxUserImageWidth || image.getHeight() > Config.getInstance().maxUserImageHeight) {
            this.error("too_large", e, null);
            return;
        }
        long count = ServerPaintingManager.get().getCustomServerPaintings().values().stream().filter(p -> p.author.equals(e.func_146103_bH().getName())).count();
        if (count > (long)Config.getInstance().maxUserImages) {
            this.error("limit_reached", e, null);
            return;
        }
        String id = Utils.escapeString(e.func_146103_bH().getName()) + "/" + Utils.escapeString(this.name);
        ResourceLocation identifier = Main.locate(id);
        CompoundNBT nbt = this.painting;
        nbt.func_74778_a("author", e.func_146103_bH().getName());
        nbt.func_74778_a("name", this.name);
        Painting painting = Painting.fromNbt(nbt);
        painting.texture.image = image;
        ServerPaintingManager.registerPainting(identifier, painting);
        for (ServerPlayerEntity player : Objects.requireNonNull(e.func_184102_h()).func_184103_al().func_181057_v()) {
            NetworkHandler.sendToPlayer(new PaintingListMessage(identifier, painting), player);
        }
        this.error("", e, identifier);
    }

    private void error(String error, PlayerEntity e, ResourceLocation i) {
        NetworkHandler.sendToPlayer(new RegisterPaintingResponse(error, i), (ServerPlayerEntity)e);
    }
}

