/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.c2s;

import immersive_paintings.Main;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.resources.ServerPaintingManager;
import java.util.Objects;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class PaintingDeleteRequest
extends Message {
    private final String identifier;

    public PaintingDeleteRequest(ResourceLocation identifier) {
        this.identifier = identifier.toString();
    }

    public PaintingDeleteRequest(PacketBuffer b) {
        this.identifier = b.func_218666_n();
    }

    @Override
    public void encode(PacketBuffer b) {
        b.func_180714_a(this.identifier);
    }

    @Override
    public void receive(PlayerEntity e) {
        ResourceLocation identifier = new ResourceLocation(this.identifier);
        if (!ServerPaintingManager.get().getCustomServerPaintings().get((Object)identifier).author.equals(e.func_146103_bH().getName()) && !e.func_211513_k(4)) {
            Main.LOGGER.warn(String.format("Player %s tried to delete an image they do not own.", e));
            return;
        }
        Main.LOGGER.info(String.format("Player %s deleted painting %s.", e, identifier));
        ServerPaintingManager.deregisterPainting(identifier);
        for (ServerPlayerEntity player : Objects.requireNonNull(e.func_184102_h()).func_184103_al().func_181057_v()) {
            NetworkHandler.sendToPlayer(new PaintingListMessage(identifier, null), player);
        }
    }
}

