/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network.c2s;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.s2c.ImageResponse;
import immersive_paintings.resources.Painting;
import immersive_paintings.resources.ServerPaintingManager;
import immersive_paintings.util.Utils;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.util.TriConsumer;

public class ImageRequest
extends Message {
    private final String identifier;
    private final Painting.Type type;

    public ImageRequest(ResourceLocation identifier, Painting.Type type) {
        this.identifier = identifier.toString();
        this.type = type;
    }

    public ImageRequest(PacketBuffer b) {
        this.identifier = b.func_218666_n();
        this.type = (Painting.Type)b.func_179257_a(Painting.Type.class);
    }

    @Override
    public void encode(PacketBuffer b) {
        b.func_180714_a(this.identifier);
        b.func_179249_a((Enum)this.type);
    }

    @Override
    public void receive(PlayerEntity e) {
        ResourceLocation identifier = new ResourceLocation(this.identifier);
        Optional<byte[]> image = ServerPaintingManager.getImageData(identifier, this.type);
        image.ifPresent(i -> Utils.processByteArrayInChunks(i, (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToClient(new ImageResponse(identifier, this.type, (byte[])ints, (int)split, (int)splits), (ServerPlayerEntity)e))));
    }
}

