/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.cobalt.network.Message;
import immersive_paintings.entity.ImmersivePaintingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public abstract class PaintingDataMessage
extends Message {
    final String motive;
    final String frame;
    final String material;
    final int entityId;
    private final Direction facing;
    private final int rotation;
    private final int x;
    private final int y;
    private final int z;

    public PaintingDataMessage(ImmersivePaintingEntity painting) {
        this.entityId = painting.func_145782_y();
        this.motive = painting.getMotive().toString();
        this.frame = painting.getFrame().toString();
        this.material = painting.getMaterial().toString();
        this.facing = painting.func_174811_aO();
        this.rotation = painting.getRotation();
        this.x = painting.getAttachmentPos().func_177958_n();
        this.y = painting.getAttachmentPos().func_177956_o();
        this.z = painting.getAttachmentPos().func_177952_p();
    }

    public PaintingDataMessage(PacketBuffer b) {
        this.entityId = b.readInt();
        this.motive = b.func_218666_n();
        this.frame = b.func_218666_n();
        this.material = b.func_218666_n();
        this.facing = Direction.func_82600_a((int)b.readInt());
        this.rotation = b.readInt();
        this.x = b.readInt();
        this.y = b.readInt();
        this.z = b.readInt();
    }

    @Override
    public void encode(PacketBuffer b) {
        b.writeInt(this.entityId);
        b.func_180714_a(this.motive);
        b.func_180714_a(this.frame);
        b.func_180714_a(this.material);
        b.writeInt(this.facing.func_176745_a());
        b.writeInt(this.rotation);
        b.writeInt(this.x);
        b.writeInt(this.y);
        b.writeInt(this.z);
    }

    public ResourceLocation getMotive() {
        return new ResourceLocation(this.motive);
    }

    public ResourceLocation getFrame() {
        return new ResourceLocation(this.frame);
    }

    public int getRotation() {
        return this.rotation;
    }

    public ResourceLocation getMaterial() {
        return new ResourceLocation(this.material);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public BlockPos getPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

