/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.Config;
import immersive_paintings.cobalt.network.Message;
import immersive_paintings.cobalt.network.NetworkHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.ServerPlayerEntity;

public class LazyNetworkManager {
    private static final List<LazyPacket> serverQueue = new LinkedList<LazyPacket>();
    private static final List<LazyPacket> clientQueue = new LinkedList<LazyPacket>();
    private static double cooldownClient = 0.0;
    private static double cooldownServer = 0.0;

    public static void sendToServer(Message message) {
        serverQueue.add(new LazyPacket(message, null));
    }

    public static void sendToClient(Message message, ServerPlayerEntity e) {
        clientQueue.add(new LazyPacket(message, e));
    }

    public static void tickClient() {
        for (cooldownClient = Math.max(cooldownClient - 1.0, 0.0); !serverQueue.isEmpty() && cooldownClient < 1.0; cooldownClient += 20.0 / (double)Config.getInstance().maxPacketsPerSecond) {
            LazyPacket packet = serverQueue.remove(0);
            NetworkHandler.sendToServer(packet.message);
        }
    }

    public static void tickServer() {
        for (cooldownServer = Math.max(cooldownServer - 1.0, 0.0); !clientQueue.isEmpty() && cooldownServer < 1.0; cooldownServer += 20.0 / (double)Config.getInstance().maxPacketsPerSecond) {
            LazyPacket packet = clientQueue.remove(0);
            NetworkHandler.sendToPlayer(packet.message, packet.player);
        }
    }

    public static float getRemainingTime() {
        return (float)serverQueue.size() / (float)Config.getInstance().maxPacketsPerSecond;
    }

    static class LazyPacket {
        final Message message;
        final ServerPlayerEntity player;

        LazyPacket(Message message, ServerPlayerEntity player) {
            this.message = message;
            this.player = player;
        }
    }
}

