/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.client.gui.ImmersivePaintingScreen;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.NetworkManager;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.s2c.OpenGuiRequest;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.network.s2c.PaintingModifyMessage;
import immersive_paintings.network.s2c.RegisterPaintingResponse;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;

public class ClientNetworkManager
implements NetworkManager {
    @Override
    public void handleOpenGuiRequest(OpenGuiRequest request) {
        if (request.gui == OpenGuiRequest.Type.EDITOR) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ImmersivePaintingScreen(request.entity));
        }
    }

    @Override
    public void handlePaintingListResponse(PaintingListMessage response) {
        if (response.shouldClear()) {
            ClientPaintingManager.getPaintings().clear();
        }
        ImmersivePaintingScreen.showOtherPlayersPaintings = response.shouldShowOtherPlayersPaintings();
        for (Map.Entry<ResourceLocation, Painting> entry : response.getPaintings().entrySet()) {
            if (entry.getValue() == null) {
                ClientPaintingManager.getPaintings().remove(entry.getKey());
                continue;
            }
            ClientPaintingManager.getPaintings().put(entry.getKey(), entry.getValue());
        }
        if (Minecraft.func_71410_x().field_71462_r instanceof ImmersivePaintingScreen) {
            ((ImmersivePaintingScreen)Minecraft.func_71410_x().field_71462_r).refreshPage();
        }
    }

    @Override
    public void handlePaintingModifyMessage(PaintingModifyMessage message) {
        Entity entity;
        ClientPlayerEntity e = Minecraft.func_71410_x().field_71439_g;
        if (e != null && (entity = e.field_70170_p.func_73045_a(message.getEntityId())) instanceof ImmersivePaintingEntity) {
            ImmersivePaintingEntity painting = (ImmersivePaintingEntity)entity;
            painting.setMotive(message.getMotive());
            painting.setFrame(message.getFrame());
            painting.setMaterial(message.getMaterial());
            painting.setFacing(message.getFacing(), message.getRotation());
            painting.setAttachmentPos(message.getPos());
        }
    }

    @Override
    public void handleRegisterPaintingResponse(RegisterPaintingResponse response) {
        if (Minecraft.func_71410_x().field_71462_r instanceof ImmersivePaintingScreen) {
            ImmersivePaintingScreen screen = (ImmersivePaintingScreen)Minecraft.func_71410_x().field_71462_r;
            if (response.error.isEmpty()) {
                if (screen.entity != null) {
                    screen.entity.setMotive(new ResourceLocation(response.identifier));
                    NetworkHandler.sendToServer(new PaintingModifyRequest(screen.entity));
                    screen.setPage(ImmersivePaintingScreen.Page.FRAME);
                }
            } else {
                screen.setPage(ImmersivePaintingScreen.Page.CREATE);
                screen.setError(new TranslationTextComponent("immersive_paintings.error." + response.error));
            }
        }
    }
}

