/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.item;

import immersive_paintings.entity.AbstractImmersiveDecorationEntity;
import immersive_paintings.entity.ImmersivePaintingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ImmersivePaintingItem
extends Item {
    public ImmersivePaintingItem(Item.Properties settings) {
        super(settings);
    }

    protected ImmersivePaintingEntity newPainting(World world, BlockPos attachmentPosition, Direction direction, int rotation) {
        return new ImmersivePaintingEntity(world, attachmentPosition, direction, rotation);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockPos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        BlockPos attachmentPosition = blockPos.func_177972_a(direction);
        PlayerEntity playerEntity = context.func_195999_j();
        ItemStack itemStack = context.func_195996_i();
        if (playerEntity != null && !this.canPlaceOn(playerEntity, direction, itemStack, attachmentPosition)) {
            return ActionResultType.FAIL;
        }
        int rotation = 0;
        if (playerEntity != null && direction.func_176740_k().func_200128_b()) {
            rotation = (int)((double)(playerEntity.func_195046_g(1.0f) / 90.0f) + (direction == Direction.UP ? 2.5 : 0.5)) * 90;
        }
        World world = context.func_195991_k();
        ImmersivePaintingEntity paintingEntity = this.newPainting(world, attachmentPosition, direction, rotation);
        CompoundNBT nbtCompound = itemStack.func_196082_o();
        if (nbtCompound != null) {
            EntityType.func_208048_a((World)world, (PlayerEntity)playerEntity, (Entity)paintingEntity, (CompoundNBT)nbtCompound);
        }
        if (paintingEntity.canStayAttached()) {
            if (!world.field_72995_K) {
                ((AbstractImmersiveDecorationEntity)paintingEntity).onPlace();
                world.func_217376_c((Entity)paintingEntity);
            }
            itemStack.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.CONSUME;
    }

    protected boolean canPlaceOn(PlayerEntity player, Direction side, ItemStack stack, BlockPos pos) {
        return player.func_175151_a(pos, side, stack);
    }
}

