/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.forge.cobalt.registration;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import immersive_paintings.cobalt.registration.Registration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class RegistrationImpl
extends Registration.Impl {
    public static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeModifierMap.MutableAttribute>> ENTITY_ATTRIBUTES = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeModifierMap.MutableAttribute>>();
    private final Map<String, RegistryRepo> repos = new HashMap<String, RegistryRepo>();

    public static void bootstrap() {
    }

    private RegistryRepo getRepo(String namespace) {
        return this.repos.computeIfAbsent(namespace, RegistryRepo::new);
    }

    @Override
    public <T extends Entity> void registerEntityRenderer(EntityType<T> type, Function<EntityRendererManager, EntityRenderer<T>> constructor) {
        RenderingRegistry.registerEntityRenderingHandler(type, constructor::apply);
    }

    @Override
    public <T> T register(Registry<? super T> registry, ResourceLocation id, T obj) {
        DeferredRegister reg = this.getRepo(id.func_110624_b()).get(registry);
        if (reg != null) {
            reg.register(id.func_110623_a(), () -> obj);
        } else {
            if (obj instanceof IForgeRegistryEntry) {
                ((IForgeRegistryEntry)obj).setRegistryName(id);
            }
            Registry.func_218322_a(registry, (ResourceLocation)id, obj);
        }
        return obj;
    }

    @Override
    public Supplier<BasicParticleType> simpleParticle() {
        return () -> new BasicParticleType(false);
    }

    @Override
    public ItemGroup itemGroup(ResourceLocation id, final Supplier<ItemStack> icon) {
        return new ItemGroup(ItemGroup.getGroupCountSafe(), String.format("%s.%s", id.func_110624_b(), id.func_110623_a())){

            public ItemStack func_78016_d() {
                return (ItemStack)icon.get();
            }
        };
    }

    @Override
    public Function<ResourceLocation, Activity> activity() {
        return id -> this.register((Registry)Registry.field_218375_Q, (ResourceLocation)id, (Object)new Activity(id.toString()));
    }

    @Override
    public <T extends Sensor<?>> BiFunction<ResourceLocation, Supplier<T>, SensorType<T>> sensor() {
        return (id, factory) -> this.register((Registry)Registry.field_218373_O, (ResourceLocation)id, (Object)new SensorType(factory));
    }

    @Override
    public <U> BiFunction<ResourceLocation, Optional<Codec<U>>, MemoryModuleType<U>> memoryModule() {
        return (id, codec) -> this.register((Registry)Registry.field_218372_N, (ResourceLocation)id, (Object)new MemoryModuleType(codec));
    }

    @Override
    public <T extends LivingEntity> BiFunction<EntityType<T>, Supplier<AttributeModifierMap.MutableAttribute>, EntityType<T>> defaultEntityAttributes() {
        return (type, attributes) -> {
            ENTITY_ATTRIBUTES.put((EntityType<? extends LivingEntity>)type, (Supplier<AttributeModifierMap.MutableAttribute>)attributes);
            return type;
        };
    }

    @Override
    public Registration.ProfessionFactory<VillagerProfession> profession() {
        return (id, poi, sound, items, sites) -> this.register((Registry)Registry.field_218370_L, id, (Object)new VillagerProfession(id.toString().replace(':', '.'), poi, ImmutableSet.copyOf((Iterable)items), ImmutableSet.copyOf((Iterable)sites), sound));
    }

    static class RegistryRepo {
        private final Set<ResourceLocation> skipped = new HashSet<ResourceLocation>();
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();
        private final String namespace;

        public RegistryRepo(String namespace) {
            this.namespace = namespace;
        }

        public <T> DeferredRegister get(Registry<? super T> registry) {
            ResourceLocation id = registry.func_243578_f().func_240901_a_();
            if (!this.registries.containsKey(id) && !this.skipped.contains(id)) {
                ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(id);
                if (reg == null) {
                    this.skipped.add(id);
                    return null;
                }
                DeferredRegister def = DeferredRegister.create((IForgeRegistry)((IForgeRegistry)Objects.requireNonNull(reg, "Registry=" + id)), (String)this.namespace);
                def.register(FMLJavaModLoadingContext.get().getModEventBus());
                this.registries.put(id, def);
            }
            return this.registries.get(id);
        }
    }
}

