/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.entity;

import immersive_paintings.Entities;
import immersive_paintings.Items;
import immersive_paintings.Main;
import immersive_paintings.ServerDataManager;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.compat.XercaPaintCompat;
import immersive_paintings.entity.AbstractImmersiveDecorationEntity;
import immersive_paintings.network.s2c.OpenGuiRequest;
import immersive_paintings.network.s2c.PaintingModifyMessage;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.ServerPaintingManager;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class ImmersivePaintingEntity
extends AbstractImmersiveDecorationEntity {
    private ResourceLocation motive = Main.locate("none");
    private ResourceLocation frame = Main.locate("none");
    private ResourceLocation material = Main.locate("none");
    private int width;
    private int height;

    public ImmersivePaintingEntity(World world, BlockPos pos, Direction direction, int rotation) {
        super(Entities.PAINTING, world, pos);
        this.setFacing(direction, rotation);
    }

    public ImmersivePaintingEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public ImmersivePaintingEntity(EntityType<?> painting, World world, BlockPos pos) {
        super(painting, world, pos);
    }

    @Override
    public int getWidthPixels() {
        return this.width * 16;
    }

    @Override
    public int getHeightPixels() {
        return this.height * 16;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74778_a("Motive", this.motive.toString());
        nbt.func_74778_a("Frame", this.frame.toString());
        nbt.func_74778_a("Material", this.material.toString());
        super.func_213281_b(nbt);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        this.motive = new ResourceLocation(nbt.func_74779_i("Motive"));
        this.frame = new ResourceLocation(nbt.func_74779_i("Frame"));
        this.material = new ResourceLocation(nbt.func_74779_i("Material"));
        this.updateMotiveDimensions();
        super.func_70037_a(nbt);
    }

    public Item getDrop() {
        return Items.PAINTING;
    }

    @Override
    public void onBreak(@Nullable Entity entity) {
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            return;
        }
        this.func_184185_a(SoundEvents.field_187691_dJ, 1.0f, 1.0f);
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        this.func_199703_a((IItemProvider)this.getDrop());
    }

    @Override
    public void onPlace() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        BlockPos blockPos = this.attachmentPos.func_177963_a(x - this.func_226277_ct_(), y - this.func_226278_cu_(), z - this.func_226281_cx_());
        this.func_70107_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public IPacket<?> func_213297_N() {
        BlockPos pos = this.getAttachmentPos();
        return new SSpawnObjectPacket(this.func_145782_y(), this.func_110124_au(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.field_70125_A, this.field_70177_z, this.func_200600_R(), 0, this.func_213322_ci());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        ServerDataManager.playerRequestedImages(player);
        NetworkHandler.sendToPlayer(new PaintingModifyMessage(this), player);
        super.func_184178_b(player);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            if (!XercaPaintCompat.interactWithPainting(this, player, hand)) {
                NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.EDITOR, this.func_145782_y()), (ServerPlayerEntity)player);
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public ResourceLocation getMotive() {
        return this.motive;
    }

    public void setMotive(ResourceLocation motive) {
        this.motive = motive;
        this.updateMotiveDimensions();
        this.updateAttachmentPosition();
    }

    public void updateMotiveDimensions() {
        if (this.field_70170_p.field_72995_K) {
            this.width = ClientPaintingManager.getPainting((ResourceLocation)this.motive).width;
            this.height = ClientPaintingManager.getPainting((ResourceLocation)this.motive).height;
        } else {
            this.width = ServerPaintingManager.getPainting((ResourceLocation)this.motive).width;
            this.height = ServerPaintingManager.getPainting((ResourceLocation)this.motive).height;
        }
    }

    public ResourceLocation getFrame() {
        return this.frame;
    }

    public void setFrame(ResourceLocation frame) {
        this.frame = frame;
    }

    public ResourceLocation getMaterial() {
        return this.material;
    }

    public void setMaterial(ResourceLocation material) {
        this.material = material;
    }
}

