/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.entity;

import immersive_paintings.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractImmersiveDecorationEntity
extends Entity {
    protected static final Predicate<Entity> PREDICATE = entity -> entity instanceof AbstractImmersiveDecorationEntity;
    private int obstructionCheckCounter;
    protected BlockPos attachmentPos;
    protected Direction facing = Direction.SOUTH;
    protected int rotation = 0;
    private static final Map<Direction, Byte> DIRECTION_TO_ID = new HashMap<Direction, Byte>(){
        {
            this.put(Direction.DOWN, (byte)5);
            this.put(Direction.UP, (byte)4);
            this.put(Direction.NORTH, (byte)2);
            this.put(Direction.SOUTH, (byte)0);
            this.put(Direction.WEST, (byte)1);
            this.put(Direction.EAST, (byte)3);
        }
    };
    private static final Map<Byte, Direction> ID_TO_DIRECTION = new HashMap<Byte, Direction>(){
        {
            this.put((byte)5, Direction.DOWN);
            this.put((byte)4, Direction.UP);
            this.put((byte)2, Direction.NORTH);
            this.put((byte)0, Direction.SOUTH);
            this.put((byte)1, Direction.WEST);
            this.put((byte)3, Direction.EAST);
        }
    };

    protected AbstractImmersiveDecorationEntity(EntityType<? extends Entity> entityType, World world) {
        super(entityType, world);
    }

    protected AbstractImmersiveDecorationEntity(EntityType<? extends Entity> type, World world, BlockPos pos) {
        this(type, world);
        this.attachmentPos = pos;
    }

    protected void func_70088_a() {
    }

    public void setFacing(Direction facing, int rotation) {
        this.facing = facing;
        this.rotation = rotation;
        if (this.facing.func_176740_k().func_176722_c()) {
            this.field_70177_z = this.facing.func_176736_b() * 90;
            this.field_70125_A = 0.0f;
        } else {
            this.field_70177_z = rotation;
            this.field_70125_A = this.facing == Direction.UP ? 90.0f : -90.0f;
        }
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.func_195050_f(1.0f);
        this.updateAttachmentPosition();
    }

    protected void updateAttachmentPosition() {
        if (this.facing == null) {
            return;
        }
        double x = (double)this.attachmentPos.func_177958_n() + 0.5;
        double y = (double)this.attachmentPos.func_177956_o() + 0.5;
        double z = (double)this.attachmentPos.func_177952_p() + 0.5;
        double ox = this.isEven(this.getWidthPixels());
        double oy = this.isEven(this.getHeightPixels());
        Vector3i front = this.facing.func_176730_m();
        Vector3i up = this.facing.func_176740_k().func_200128_b() ? new Vector3i(0, 0, 1) : new Vector3i(0, 1, 0);
        Vector3i side = up.func_177955_d(front);
        if (this.rotation != 0) {
            double cos = Math.cos((double)this.rotation / 180.0 * Math.PI);
            double sin = Math.sin((double)this.rotation / 180.0 * Math.PI);
            up = new Vector3i((double)Math.round((double)up.func_177958_n() * cos - (double)up.func_177952_p() * sin), (double)up.func_177956_o(), (double)Math.round((double)up.func_177958_n() * sin + (double)up.func_177952_p() * cos));
            side = new Vector3i((double)Math.round((double)side.func_177958_n() * cos - (double)side.func_177952_p() * sin), (double)side.func_177956_o(), (double)Math.round((double)side.func_177958_n() * sin + (double)side.func_177952_p() * cos));
        }
        double w = (double)this.getWidthPixels() / 32.0;
        double h = (double)this.getHeightPixels() / 32.0;
        double d = 0.03125;
        this.func_226288_n_(x -= (double)this.facing.func_82601_c() * 7.5 / 16.0 - (double)up.func_177958_n() * oy - (double)side.func_177958_n() * ox, y -= (double)this.facing.func_96559_d() * 7.5 / 16.0 - (double)up.func_177956_o() * oy - (double)side.func_177956_o() * ox, z -= (double)this.facing.func_82599_e() * 7.5 / 16.0 - (double)up.func_177952_p() * oy - (double)side.func_177952_p() * ox);
        this.func_174826_a(new AxisAlignedBB(x - (double)up.func_177958_n() * h - (double)side.func_177958_n() * w - (double)front.func_177958_n() * d, y - (double)up.func_177956_o() * h - (double)side.func_177956_o() * w - (double)front.func_177956_o() * d, z - (double)up.func_177952_p() * h - (double)side.func_177952_p() * w - (double)front.func_177952_p() * d, x + (double)up.func_177958_n() * h + (double)side.func_177958_n() * w + (double)front.func_177958_n() * d, y + (double)up.func_177956_o() * h + (double)side.func_177956_o() * w + (double)front.func_177956_o() * d, z + (double)up.func_177952_p() * h + (double)side.func_177952_p() * w + (double)front.func_177952_p() * d));
    }

    private double isEven(int i) {
        return i % 32 == 0 ? 0.5 : 0.0;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_226278_cu_() < -64.0) {
                this.func_70076_C();
            }
            if (this.obstructionCheckCounter++ == 100) {
                this.obstructionCheckCounter = 0;
                if (!this.field_70128_L && !this.canStayAttached()) {
                    this.func_70106_y();
                    this.onBreak(null);
                }
            }
        }
    }

    public boolean canStayAttached() {
        if (Config.getInstance().testIfSpaceEmpty && !this.field_70170_p.func_226669_j_((Entity)this)) {
            return false;
        }
        BlockPos blockPos = this.attachmentPos.func_177972_a(this.facing.func_176734_d());
        BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
        if (!blockState.func_185904_a().func_76220_a() && !RedstoneDiodeBlock.func_185546_B((BlockState)blockState)) {
            return false;
        }
        return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), PREDICATE).stream().noneMatch(v -> ((AbstractImmersiveDecorationEntity)v).facing == this.facing);
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_85031_j(Entity attacker) {
        if (attacker instanceof PlayerEntity) {
            if (!this.field_70170_p.func_175660_a((PlayerEntity)attacker, this.attachmentPos)) {
                return true;
            }
            return this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), 0.0f);
        }
        return false;
    }

    public Direction func_174811_aO() {
        return this.facing;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.onBreak(source.func_76346_g());
        }
        return true;
    }

    public void func_213315_a(MoverType movementType, Vector3d movement) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && movement.func_189985_c() > 0.0) {
            this.func_174812_G();
            this.onBreak(null);
        }
    }

    public void func_70024_g(double deltaX, double deltaY, double deltaZ) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ > 0.0) {
            this.func_174812_G();
            this.onBreak(null);
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74768_a("TileX", this.attachmentPos.func_177958_n());
        nbt.func_74768_a("TileY", this.attachmentPos.func_177956_o());
        nbt.func_74768_a("TileZ", this.attachmentPos.func_177952_p());
        nbt.func_74774_a("Facing", DIRECTION_TO_ID.get(this.facing).byteValue());
        nbt.func_74768_a("Rotation", this.rotation);
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.attachmentPos = new BlockPos(nbt.func_74762_e("TileX"), nbt.func_74762_e("TileY"), nbt.func_74762_e("TileZ"));
        this.facing = ID_TO_DIRECTION.get(nbt.func_74771_c("Facing"));
        this.rotation = nbt.func_74762_e("Rotation");
        this.setFacing(this.facing, this.rotation);
    }

    public abstract int getWidthPixels();

    public abstract int getHeightPixels();

    public abstract void onBreak(@Nullable Entity var1);

    public abstract void onPlace();

    public ItemEntity func_70099_a(ItemStack stack, float yOffset) {
        ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + (double)((float)this.facing.func_82601_c() * 0.15f), this.func_226278_cu_() + (double)yOffset, this.func_226281_cx_() + (double)((float)this.facing.func_82599_e() * 0.15f), stack);
        itemEntity.func_174869_p();
        this.field_70170_p.func_217376_c((Entity)itemEntity);
        return itemEntity;
    }

    protected boolean func_142008_O() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        this.attachmentPos = new BlockPos(x, y, z);
        this.updateAttachmentPosition();
        this.field_70160_al = true;
    }

    public float func_184229_a(Rotation rotation) {
        if (this.facing.func_176740_k() != Direction.Axis.Y) {
            switch (rotation) {
                case CLOCKWISE_180: {
                    this.facing = this.facing.func_176734_d();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.facing = this.facing.func_176735_f();
                    break;
                }
                case CLOCKWISE_90: {
                    this.facing = this.facing.func_176746_e();
                }
            }
        }
        float f = MathHelper.func_76142_g((float)this.field_70177_z);
        switch (rotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    public float func_184217_a(Mirror mirror) {
        return this.func_184229_a(mirror.func_185800_a(this.facing));
    }

    public void func_241841_a(ServerWorld world, LightningBoltEntity lightning) {
    }

    public void func_213323_x_() {
    }

    public BlockPos getAttachmentPos() {
        return this.attachmentPos;
    }

    public void setAttachmentPos(BlockPos pos) {
        this.attachmentPos = pos;
        this.updateAttachmentPosition();
    }
}

