/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.compat;

import immersive_paintings.Main;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.c2s.RegisterPaintingRequest;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.Utils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.util.TriConsumer;

public class XercaPaintCompat {
    public static boolean interactWithPainting(ImmersivePaintingEntity painting, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ResourceLocation id = Registry.field_212630_s.func_177774_c((Object)stack.func_77973_b());
        if (id.func_110624_b().equals("xercapaint")) {
            int w = 0;
            int h = 0;
            if (id.func_110623_a().equals("item_canvas")) {
                w = 16;
                h = 16;
            } else if (id.func_110623_a().equals("item_canvas_large")) {
                w = 32;
                h = 32;
            } else if (id.func_110623_a().equals("item_canvas_long")) {
                w = 32;
                h = 16;
            } else if (id.func_110623_a().equals("item_canvas_tall")) {
                w = 16;
                h = 32;
            }
            CompoundNBT nbt = stack.func_77978_p();
            if (w > 0 && nbt != null && nbt.func_74764_b("pixels")) {
                int[] pixels = nbt.func_74759_k("pixels");
                BufferedImage bufferedImage = new BufferedImage(w, h, 1);
                int x = 0;
                int y = 0;
                for (int n : pixels) {
                    bufferedImage.setRGB(x, y, n);
                    if (++x < w) continue;
                    x = 0;
                    ++y;
                }
                String title = nbt.func_74764_b("title") ? nbt.func_74779_i("title") : (nbt.func_74764_b("ip_title") ? nbt.func_74779_i("ip_title") : "Unnamed Painting #" + player.func_70681_au().nextInt(0x100000));
                nbt.func_74778_a("ip_title", title);
                try {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", stream);
                    Utils.processByteArrayInChunks(stream.toByteArray(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new UploadPaintingRequest((byte[])ints, (int)split, (int)splits))));
                    LazyNetworkManager.sendToServer(new RegisterPaintingRequest(title, new Painting(null, w / 16, h / 16, 16, false)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String name = Utils.escapeString(player.func_146103_bH().getName()) + "/" + Utils.escapeString(title);
                ResourceLocation identifier = Main.locate(name);
                painting.setMotive(identifier);
                LazyNetworkManager.sendToServer(new PaintingModifyRequest(painting));
                return true;
            }
        }
        return false;
    }
}

