/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.client.render.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.ObjectLoader;
import immersive_paintings.resources.Painting;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import owens.oobjloader.Face;
import owens.oobjloader.FaceVertex;

public class ImmersivePaintingEntityRenderer<T extends ImmersivePaintingEntity>
extends EntityRenderer<T> {
    public ImmersivePaintingEntityRenderer(EntityRendererManager dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float yaw, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int light) {
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-entity.func_195050_f(tickDelta)));
        matrixStack.func_227862_a_(0.0625f, 0.0625f, 0.0625f);
        this.renderPainting(matrixStack, vertexConsumerProvider, entity);
        matrixStack.func_227865_b_();
        super.func_225623_a_(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    public ResourceLocation getTexture(T paintingEntity) {
        int resolution;
        Minecraft client = Minecraft.func_71410_x();
        Config config = Config.getInstance();
        ClientPlayerEntity player = client.field_71439_g;
        double distance = player == null ? 0.0 : player.func_213303_ch().func_72438_d(paintingEntity.func_213303_ch());
        double blocksVisible = Math.tan(client.field_71474_y.field_74334_X / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        double pixelDensity = blocksVisible * (double)(resolution = ClientPaintingManager.getPainting((ResourceLocation)((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive()).resolution) / (double)client.func_228018_at_().func_198083_n();
        Painting.Type type = pixelDensity > (double)config.eighthResolutionThreshold ? Painting.Type.EIGHTH : (pixelDensity > (double)config.quarterResolutionThreshold ? Painting.Type.QUARTER : (pixelDensity > (double)config.halfResolutionThreshold ? Painting.Type.HALF : Painting.Type.FULL));
        return ClientPaintingManager.getPaintingTexture((ResourceLocation)((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive(), (Painting.Type)type).textureIdentifier;
    }

    protected int getLight(int light) {
        return light;
    }

    protected int getFrameLight(int light) {
        return light;
    }

    private void renderPainting(MatrixStack matrices, IRenderTypeBuffer vertexConsumerProvider, T entity) {
        int light = WorldRenderer.func_228421_a_((IBlockDisplayReader)((ImmersivePaintingEntity)((Object)entity)).field_70170_p, (BlockPos)entity.func_233580_cy_());
        MatrixStack.Entry entry = matrices.func_227866_c_();
        Matrix4f posMat = entry.func_227870_a_();
        Matrix3f normMat = entry.func_227872_b_();
        boolean hasFrame = !((ImmersivePaintingEntity)((Object)entity)).getFrame().func_110623_a().equals("none");
        int width = ((ImmersivePaintingEntity)((Object)entity)).getWidthPixels();
        int height = ((ImmersivePaintingEntity)((Object)entity)).getHeightPixels();
        IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228634_a_((ResourceLocation)this.getTexture(entity)));
        this.renderFaces("objects/canvas.obj", posMat, normMat, vertexConsumer, this.getLight(light), width, height, hasFrame ? 1.0f : 0.0f);
        int frameLight = this.getFrameLight(light);
        if (hasFrame) {
            vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228638_b_((ResourceLocation)((ImmersivePaintingEntity)((Object)entity)).getMaterial()));
            this.renderFrame(((ImmersivePaintingEntity)((Object)entity)).getFrame(), posMat, normMat, vertexConsumer, frameLight, width, height);
        }
    }

    private void renderFaces(String name, Matrix4f posMat, Matrix3f normMat, IVertexBuilder vertexConsumer, int light, float width, float height, float margin) {
        List<Face> faces = ObjectLoader.objects.get(Main.locate(name));
        for (Face face : faces) {
            for (FaceVertex v : face.vertices) {
                this.vertex(posMat, normMat, vertexConsumer, v.v.x * (width - margin * 2.0f), v.v.y * (height - margin * 2.0f), v.v.z * 16.0f, v.t.u * (width - margin * 2.0f) / width + margin / width, (1.0f - v.t.v) * (height - margin * 2.0f) / height + margin / height, v.n.x, v.n.y, v.n.z, light);
            }
        }
    }

    private List<Face> getFaces(ResourceLocation frame, String part) {
        ResourceLocation id = new ResourceLocation(frame.func_110624_b(), frame.func_110623_a() + "/" + part + ".obj");
        if (ObjectLoader.objects.containsKey(id)) {
            return ObjectLoader.objects.get(id);
        }
        return new LinkedList<Face>();
    }

    private void renderFrame(ResourceLocation frame, Matrix4f posMat, Matrix3f normMat, IVertexBuilder vertexConsumer, int light, float width, float height) {
        float u;
        List<Face> faces = this.getFaces(frame, "bottom");
        int x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "top");
        x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y + (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "right");
        int y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x + (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
        faces = this.getFaces(frame, "left");
        y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(posMat, normMat, vertexConsumer, v.v.x - (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
    }

    private void vertex(Matrix4f positionMatrix, Matrix3f normalMatrix, IVertexBuilder vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light) {
        vertexConsumer.func_227888_a_(positionMatrix, x, y, z - 0.5f).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, normalX, normalY, normalZ).func_181675_d();
    }
}

