/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import immersive_paintings.Config;
import immersive_paintings.Main;
import immersive_paintings.client.ClientUtils;
import immersive_paintings.client.gui.widget.CallbackCheckboxWidget;
import immersive_paintings.client.gui.widget.IntegerSliderWidget;
import immersive_paintings.client.gui.widget.PaintingWidget;
import immersive_paintings.client.gui.widget.PercentageSliderWidget;
import immersive_paintings.client.gui.widget.TexturedButtonWidget;
import immersive_paintings.client.gui.widget.TooltipButtonWidget;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.LazyNetworkManager;
import immersive_paintings.network.c2s.PaintingDeleteRequest;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.c2s.RegisterPaintingRequest;
import immersive_paintings.network.c2s.UploadPaintingRequest;
import immersive_paintings.resources.ByteImage;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Frame;
import immersive_paintings.resources.FrameLoader;
import immersive_paintings.resources.Painting;
import immersive_paintings.util.FlowingText;
import immersive_paintings.util.ImageManipulations;
import immersive_paintings.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ImmersivePaintingScreen
extends Screen {
    private static final int SCREENSHOTS_PER_PAGE = 5;
    public static boolean showOtherPlayersPaintings;
    final int entityId;
    public ImmersivePaintingEntity entity;
    private String filteredString = "";
    private int filteredResolution = 0;
    private int filteredWidth = 0;
    private int filteredHeight = 0;
    private final List<ResourceLocation> filteredPaintings = new ArrayList<ResourceLocation>();
    private int selectionPage;
    private Page page;
    private Button pageWidget;
    private final List<PaintingWidget> paintingWidgetList = new LinkedList<PaintingWidget>();
    private ByteImage currentImage;
    private static int currentImagePixelZoomCache;
    private String currentImageName;
    private PixelatorSettings settings;
    private ByteImage pixelatedImage;
    private List<File> screenshots = new LinkedList<File>();
    private int screenshotPage;
    private ResourceLocation deletePainting;
    private TranslationTextComponent error;
    private boolean shouldReProcess;
    private static volatile boolean shouldUpload;
    final ExecutorService service = Executors.newFixedThreadPool(1);

    public ImmersivePaintingScreen(int entityId) {
        super((ITextComponent)new TranslationTextComponent("item.immersive_paintings.painting"));
        Entity painting;
        this.entityId = entityId;
        if (Minecraft.func_71410_x().field_71441_e != null && (painting = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityId)) instanceof ImmersivePaintingEntity) {
            this.entity = (ImmersivePaintingEntity)painting;
        }
        if (this.entity == null) {
            this.func_231175_as__();
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.clearSearch();
        this.setPage(Page.DATAPACKS);
        this.updateSearch();
        File file = new File(Minecraft.func_71410_x().field_71412_D, "screenshots");
        File[] files = file.listFiles(v -> v.getName().endsWith(".png"));
        if (files != null) {
            this.screenshots = Arrays.stream(files).collect(Collectors.toList());
        }
    }

    private void clearSearch() {
        this.filteredString = "";
        this.filteredResolution = 0;
        this.filteredWidth = 0;
        this.filteredHeight = 0;
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        switch (this.page) {
            case NEW: {
                ImmersivePaintingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.field_230708_k_ / 2 - 115), (int)(this.field_230709_l_ / 2 - 68), (int)(this.field_230708_k_ / 2 + 115), (int)(this.field_230709_l_ / 2 - 41), (int)0x50000000);
                List<ITextComponent> wrap = FlowingText.wrap((ITextComponent)new TranslationTextComponent("immersive_paintings.drop"), 220);
                int y = this.field_230709_l_ / 2 - 40 - wrap.size() * 12;
                for (ITextComponent text : wrap) {
                    ImmersivePaintingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)text, (int)(this.field_230708_k_ / 2), (int)y, (int)-1);
                    y += 12;
                }
                break;
            }
            case CREATE: {
                if (this.shouldReProcess && this.currentImage != null) {
                    Runnable task = () -> {
                        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
                        shouldUpload = true;
                    };
                    this.service.submit(task);
                }
                if (shouldUpload && this.pixelatedImage != null) {
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(Main.locate("temp_pixelated"), (Texture)new DynamicTexture(ClientUtils.byteImageToNativeImage(this.pixelatedImage)));
                }
                int maxWidth = 190;
                int maxHeight = 135;
                int tw = this.settings.resolution * this.settings.width;
                int th = this.settings.resolution * this.settings.height;
                float size = Math.min((float)maxWidth / (float)tw, (float)maxHeight / (float)th);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(Main.locate("temp_pixelated"));
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableDepthTest();
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)((float)this.field_230708_k_ / 2.0f - (float)tw * size / 2.0f), (double)((float)this.field_230709_l_ / 2.0f - (float)th * size / 2.0f), 0.0);
                matrices.func_227862_a_(size, size, 1.0f);
                ImmersivePaintingScreen.func_238463_a_((MatrixStack)matrices, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)tw, (int)th, (int)tw, (int)th);
                matrices.func_227865_b_();
                if (this.error == null) break;
                ImmersivePaintingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)this.error, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)-65536);
                break;
            }
            case DELETE: {
                ImmersivePaintingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.field_230708_k_ / 2 - 160), (int)(this.field_230709_l_ / 2 - 50), (int)(this.field_230708_k_ / 2 + 160), (int)(this.field_230709_l_ / 2 + 50), (int)-2013265920);
                List<ITextComponent> wrap = FlowingText.wrap((ITextComponent)new TranslationTextComponent("immersive_paintings.confirm_deletion"), 300);
                int y = this.field_230709_l_ / 2 - 35;
                for (ITextComponent t : wrap) {
                    ImmersivePaintingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)t, (int)(this.field_230708_k_ / 2), (int)y, (int)0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case ADMIN_DELETE: {
                ImmersivePaintingScreen.func_238467_a_((MatrixStack)matrices, (int)(this.field_230708_k_ / 2 - 160), (int)(this.field_230709_l_ / 2 - 50), (int)(this.field_230708_k_ / 2 + 160), (int)(this.field_230709_l_ / 2 + 50), (int)-2013265920);
                List<ITextComponent> wrap = FlowingText.wrap((ITextComponent)new TranslationTextComponent("immersive_paintings.confirm_admin_deletion"), 300);
                int y = this.field_230709_l_ / 2 - 35;
                for (ITextComponent t : wrap) {
                    ImmersivePaintingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)t, (int)(this.field_230708_k_ / 2), (int)y, (int)0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case LOADING: {
                TranslationTextComponent text = new TranslationTextComponent("immersive_paintings.upload", new Object[]{(int)Math.ceil(LazyNetworkManager.getRemainingTime())});
                ImmersivePaintingScreen.func_238472_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (ITextComponent)text, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)-1);
            }
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private List<ResourceLocation> getMaterialsList() {
        return FrameLoader.frames.values().stream().filter(v -> v.frame().equals((Object)this.entity.getFrame())).map(Frame::material).distinct().sorted(ResourceLocation::compareTo).collect(Collectors.toList());
    }

    private void rebuild() {
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        if (this.page != Page.CREATE) {
            LinkedList<Page> b2 = new LinkedList<Page>();
            b2.add(Page.YOURS);
            b2.add(Page.DATAPACKS);
            if (showOtherPlayersPaintings || this.isOp()) {
                b2.add(Page.PLAYERS);
            }
            b2.add(Page.NEW);
            b2.add(Page.FRAME);
            int x = this.field_230708_k_ / 2 - 200;
            int w = 400 / b2.size();
            for (Page page : b2) {
                ((Button)this.func_230480_a_((Widget)new Button((int)x, (int)(this.field_230709_l_ / 2 - 90 - 22), (int)w, (int)20, (ITextComponent)new TranslationTextComponent((String)new StringBuilder().append((String)"immersive_paintings.page.").append((String)page.name().toLowerCase((Locale)Locale.ROOT)).toString()), (Button.IPressable)(Button.IPressable)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/widget/button/Button;)V, lambda$rebuild$3(immersive_paintings.client.gui.ImmersivePaintingScreen$Page net.minecraft.client.gui.widget.button.Button ), (Lnet/minecraft/client/gui/widget/button/Button;)V)((ImmersivePaintingScreen)this, (Page)page)))).field_230693_o_ = page != this.page;
                x += w;
            }
        }
        switch (this.page) {
            case NEW: {
                TextFieldWidget textFieldWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 90, this.field_230709_l_ / 2 - 38, 180, 16, (ITextComponent)new StringTextComponent("URL")));
                textFieldWidget.func_146203_f(1024);
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ / 2 - 15, 100, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.load"), sender -> this.loadImage(textFieldWidget.func_146179_b())));
                this.rebuildScreenshots();
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 65, this.field_230709_l_ / 2 + 70, 30, 20, (ITextComponent)new StringTextComponent("<<"), sender -> this.setScreenshotPage(this.screenshotPage - 1)));
                this.pageWidget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 65 + 30, this.field_230709_l_ / 2 + 70, 70, 20, (ITextComponent)new StringTextComponent(""), sender -> {}));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 65 + 100, this.field_230709_l_ / 2 + 70, 30, 20, (ITextComponent)new StringTextComponent(">>"), sender -> this.setScreenshotPage(this.screenshotPage + 1)));
                this.setScreenshotPage(this.screenshotPage);
                break;
            }
            case CREATE: {
                TextFieldWidget nameWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 90, this.field_230709_l_ / 2 - 100, 180, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.name")));
                nameWidget.func_146203_f(256);
                nameWidget.func_146180_a(this.currentImageName);
                nameWidget.func_212954_a(s -> {
                    this.currentImageName = s;
                });
                int y = this.field_230709_l_ / 2 - 60;
                this.func_230480_a_((Widget)new IntegerSliderWidget(this.field_230708_k_ / 2 - 200, y, 100, 20, "immersive_paintings.width", this.settings.width, 1, 16, v -> {
                    this.settings.width = v;
                    this.shouldReProcess = true;
                }));
                this.func_230480_a_((Widget)new IntegerSliderWidget(this.field_230708_k_ / 2 - 200, y += 22, 100, 20, "immersive_paintings.width", this.settings.height, 1, 16, v -> {
                    this.settings.height = v;
                    this.shouldReProcess = true;
                }));
                int x = this.field_230708_k_ / 2 - 200;
                TooltipButtonWidget widget = (TooltipButtonWidget)this.func_230480_a_((Widget)new TooltipButtonWidget(x + 25, y += 22, 50, 20, (ITextComponent)new StringTextComponent(String.valueOf(this.settings.resolution)), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.resolution"), v -> {}));
                this.func_230480_a_((Widget)new TooltipButtonWidget(x, y, 25, 20, (ITextComponent)new StringTextComponent("<"), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.resolution"), v -> {
                    this.settings.resolution = Math.max(Config.getInstance().minPaintingResolution, this.settings.resolution / 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    widget.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(this.settings.resolution)));
                }));
                this.func_230480_a_((Widget)new TooltipButtonWidget(x + 75, y, 25, 20, (ITextComponent)new StringTextComponent(">"), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.resolution"), v -> {
                    this.settings.resolution = Math.min(Config.getInstance().maxPaintingResolution, this.settings.resolution * 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    widget.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(this.settings.resolution)));
                }));
                y += 22;
                ((IntegerSliderWidget)this.func_230480_a_((Widget)new IntegerSliderWidget((int)(this.field_230708_k_ / 2 - 200), (int)(y += 10), (int)100, (int)20, (String)"immersive_paintings.colors", (double)12.0, (int)1, (int)25, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$14(java.lang.Integer ), (Ljava/lang/Integer;)V)((ImmersivePaintingScreen)this)))).field_230693_o_ = !this.settings.pixelArt;
                ((PercentageSliderWidget)this.func_230480_a_((Widget)new PercentageSliderWidget((int)(this.field_230708_k_ / 2 - 200), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.dither", (double)0.25, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$15(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).field_230693_o_ = !this.settings.pixelArt;
                y = this.field_230709_l_ / 2 - 50;
                this.func_230480_a_((Widget)new CallbackCheckboxWidget(this.field_230708_k_ / 2 + 100, y, 20, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.pixelart"), (ITextComponent)new TranslationTextComponent("immersive_paintings.pixelart.tooltip"), this.settings.pixelArt, true, b -> {
                    this.settings.pixelArt = b;
                    this.adaptToPixelArt();
                    this.refreshPage();
                    this.shouldReProcess = true;
                }));
                this.func_230480_a_((Widget)new CallbackCheckboxWidget(this.field_230708_k_ / 2 + 100, y += 22, 100, 20, (ITextComponent)new TranslationTextComponent(this.settings.hidden ? "immersive_paintings.show" : "immersive_paintings.hide"), (ITextComponent)new TranslationTextComponent("immersive_paintings.visibility"), this.settings.hidden, true, v -> {
                    this.settings.hidden = !this.settings.hidden;
                }));
                this.func_230480_a_((Widget)new PercentageSliderWidget(this.field_230708_k_ / 2 + 100, y += 22, 100, 20, "immersive_paintings.x_offset", 0.5, v -> {
                    this.settings.offsetX = v;
                    this.shouldReProcess = true;
                }));
                this.func_230480_a_((Widget)new PercentageSliderWidget(this.field_230708_k_ / 2 + 100, y += 22, 100, 20, "immersive_paintings.y_offset", 0.5, v -> {
                    this.settings.offsetY = v;
                    this.shouldReProcess = true;
                }));
                ((PercentageSliderWidget)this.func_230480_a_((Widget)new PercentageSliderWidget((int)(this.field_230708_k_ / 2 + 100), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.zoom", (double)1.0, (double)1.0, (double)3.0, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$20(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).field_230693_o_ = !this.settings.pixelArt;
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 85, this.field_230709_l_ / 2 + 75, 80, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.cancel"), v -> this.setPage(Page.NEW)));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 2 + 75, 80, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.save"), v -> {
                    Utils.processByteArrayInChunks(this.pixelatedImage.encode(), (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new UploadPaintingRequest((byte[])ints, (int)split, (int)splits))));
                    LazyNetworkManager.sendToServer(new RegisterPaintingRequest(this.currentImageName, new Painting(this.pixelatedImage, this.settings.width, this.settings.height, this.settings.resolution, this.settings.hidden)));
                    this.setPage(Page.LOADING);
                }));
                break;
            }
            case YOURS: 
            case DATAPACKS: 
            case PLAYERS: {
                this.rebuildPaintings();
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 35 - 30, this.field_230709_l_ / 2 + 80, 30, 20, (ITextComponent)new StringTextComponent("<<"), sender -> this.setSelectionPage(this.selectionPage - 1)));
                this.pageWidget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 35, this.field_230709_l_ / 2 + 80, 70, 20, (ITextComponent)new StringTextComponent(""), sender -> {}));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 35, this.field_230709_l_ / 2 + 80, 30, 20, (ITextComponent)new StringTextComponent(">>"), sender -> this.setSelectionPage(this.selectionPage + 1)));
                this.setSelectionPage(this.selectionPage);
                TextFieldWidget searchWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 65, this.field_230709_l_ / 2 - 88, 130, 16, (ITextComponent)new TranslationTextComponent("immersive_paintings.search")));
                searchWidget.func_146203_f(64);
                searchWidget.func_195612_c("search");
                searchWidget.func_212954_a(s -> {
                    this.filteredString = s;
                    this.updateSearch();
                    searchWidget.func_195612_c(null);
                });
                int x = this.field_230708_k_ / 2 - 200 + 12;
                Button resolutionWidget = (Button)this.func_230480_a_((Widget)new TooltipButtonWidget(x + 50 + 8, this.field_230709_l_ / 2 - 90, 25, 20, (ITextComponent)new StringTextComponent(String.valueOf(this.filteredResolution)), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.filter_resolution"), v -> {}));
                TooltipButtonWidget allWidget = (TooltipButtonWidget)this.func_230480_a_((Widget)new TooltipButtonWidget(x, this.field_230709_l_ / 2 - 90, 25, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.filter.all"), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = 0;
                    this.updateSearch();
                    resolutionWidget.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(this.filteredResolution)));
                    v.field_230693_o_ = false;
                }));
                this.func_230480_a_((Widget)new TooltipButtonWidget(x + 25 + 8, this.field_230709_l_ / 2 - 90, 25, 20, (ITextComponent)new StringTextComponent("<"), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.max(Config.getInstance().minPaintingResolution, this.filteredResolution / 2);
                    this.updateSearch();
                    resolutionWidget.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(this.filteredResolution)));
                    allWidget.field_230693_o_ = true;
                }));
                this.func_230480_a_((Widget)new TooltipButtonWidget(x + 75 + 8, this.field_230709_l_ / 2 - 90, 25, 20, (ITextComponent)new StringTextComponent(">"), (ITextComponent)new TranslationTextComponent("immersive_paintings.tooltip.filter_resolution"), v -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.min(Config.getInstance().maxPaintingResolution, this.filteredResolution * 2);
                    this.updateSearch();
                    resolutionWidget.func_238482_a_((ITextComponent)new StringTextComponent(String.valueOf(this.filteredResolution)));
                    allWidget.field_230693_o_ = true;
                }));
                TextFieldWidget widthWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 - 88, 40, 16, (ITextComponent)new TranslationTextComponent("immersive_paintings.filter_width")));
                widthWidget.func_146203_f(2);
                widthWidget.func_195612_c("width");
                widthWidget.func_212954_a(s -> {
                    try {
                        this.filteredWidth = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredWidth = 0;
                    }
                    this.updateSearch();
                    widthWidget.func_195612_c(null);
                });
                TextFieldWidget heightWidget = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 80 + 40, this.field_230709_l_ / 2 - 88, 40, 16, (ITextComponent)new TranslationTextComponent("immersive_paintings.filter_height")));
                heightWidget.func_146203_f(2);
                heightWidget.func_195612_c("height");
                heightWidget.func_212954_a(s -> {
                    try {
                        this.filteredHeight = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredHeight = 0;
                    }
                    this.updateSearch();
                    heightWidget.func_195612_c(null);
                });
                break;
            }
            case FRAME: {
                int y = this.field_230709_l_ / 2 - 80;
                List frames = FrameLoader.frames.values().stream().map(Frame::frame).distinct().sorted(ResourceLocation::compareTo).collect(Collectors.toList());
                for (ResourceLocation frame : frames) {
                    Button frameWidget = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 200, y, 100, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.frame." + Utils.identifierToTranslation(frame)), v -> {
                        this.entity.setFrame(frame);
                        this.entity.setMaterial(this.getMaterialsList().get(0));
                        NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                        this.setPage(Page.FRAME);
                    }));
                    frameWidget.field_230693_o_ = !frame.equals((Object)this.entity.getFrame());
                    y += 25;
                }
                int py = 0;
                int px = 0;
                List<ResourceLocation> materials = this.getMaterialsList();
                LinkedList<Button> materialList = new LinkedList<Button>();
                for (ResourceLocation material : materials) {
                    Button materialWidget = (Button)this.func_230480_a_((Widget)new TexturedButtonWidget(this.field_230708_k_ / 2 - 80 + px * 65, this.field_230709_l_ / 2 - 80 + py * 20, 64, 16, new ResourceLocation(material.func_110624_b(), material.func_110623_a().replace("/block/", "/gui/")), 0, 0, 64, 32, (ITextComponent)new StringTextComponent(""), v -> {
                        this.entity.setMaterial(material);
                        NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                        materialList.forEach(b -> {
                            b.field_230693_o_ = true;
                        });
                        v.field_230693_o_ = false;
                    }, (b, matrixStack, mx, my) -> this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("immersive_paintings.material." + Utils.identifierToTranslation(material)), mx, my)));
                    materialWidget.field_230693_o_ = !material.equals((Object)this.entity.getMaterial());
                    materialList.add(materialWidget);
                    if (++px <= 3) continue;
                    px = 0;
                    ++py;
                }
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 50, this.field_230709_l_ / 2 + 70, 100, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.done"), v -> this.func_231175_as__()));
                break;
            }
            case DELETE: {
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100 - 5, this.field_230709_l_ / 2 + 20, 100, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.cancel"), v -> this.setPage(Page.YOURS)));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 2 + 20, 100, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.delete"), v -> {
                    NetworkHandler.sendToServer(new PaintingDeleteRequest(this.deletePainting));
                    this.setPage(Page.YOURS);
                }));
                break;
            }
            case ADMIN_DELETE: {
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 115, this.field_230709_l_ / 2 + 10, 70, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.cancel"), v -> this.setPage(Page.PLAYERS)));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 + 10, 70, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.delete"), v -> {
                    NetworkHandler.sendToServer(new PaintingDeleteRequest(this.deletePainting));
                    this.setPage(Page.PLAYERS);
                }));
                this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 35, this.field_230709_l_ / 2 + 10, 70, 20, (ITextComponent)new TranslationTextComponent("immersive_paintings.delete_all"), v -> {
                    String author = ClientPaintingManager.getPainting((ResourceLocation)this.deletePainting).author;
                    ClientPaintingManager.getPaintings().entrySet().stream().filter(p -> Objects.equals(((Painting)p.getValue()).author, author) && !((Painting)p.getValue()).datapack).map(Map.Entry::getKey).forEach(p -> NetworkHandler.sendToServer(new PaintingDeleteRequest((ResourceLocation)p)));
                    this.setPage(Page.PLAYERS);
                }));
            }
        }
    }

    private void rebuildPaintings() {
        for (PaintingWidget w : this.paintingWidgetList) {
            this.field_230705_e_.remove((Object)w);
            this.field_230710_m_.remove((Object)w);
        }
        this.paintingWidgetList.clear();
        for (int y = 0; y < 3; ++y) {
            int i;
            for (int x = 0; x < 8 && (i = y * 8 + x + this.selectionPage * 24) >= 0 && i < this.filteredPaintings.size(); ++x) {
                ResourceLocation identifier = this.filteredPaintings.get(i);
                Painting painting = ClientPaintingManager.getPainting(identifier);
                LinkedList<Object> tooltip = new LinkedList<Object>();
                tooltip.add(new StringTextComponent(painting.name));
                tooltip.add(new TranslationTextComponent("immersive_paintings.by_author", new Object[]{painting.author}).func_240699_a_(TextFormatting.ITALIC));
                tooltip.add(new TranslationTextComponent("immersive_paintings.resolution", new Object[]{painting.width, painting.height, painting.resolution}).func_240699_a_(TextFormatting.ITALIC));
                if (this.page == Page.YOURS || painting.hidden) {
                    tooltip.add(new TranslationTextComponent("immersive_paintings.hidden").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
                }
                if (this.page == Page.YOURS || this.page == Page.PLAYERS && this.isOp()) {
                    tooltip.add(new TranslationTextComponent("immersive_paintings.right_click_to_delete").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
                }
                this.paintingWidgetList.add((PaintingWidget)this.func_230480_a_((Widget)new PaintingWidget(ClientPaintingManager.getPaintingTexture(identifier, Painting.Type.THUMBNAIL), (int)((double)(this.field_230708_k_ / 2) + ((double)x - 3.5) * 48.0) - 24, this.field_230709_l_ / 2 - 66 + y * 48, 46, 46, sender -> {
                    this.entity.setMotive(identifier);
                    NetworkHandler.sendToServer(new PaintingModifyRequest(this.entity));
                    this.setPage(Page.FRAME);
                }, b -> {
                    if (this.page == Page.YOURS) {
                        this.deletePainting = identifier;
                        this.setPage(Page.DELETE);
                    } else if (this.page == Page.PLAYERS && this.isOp()) {
                        this.deletePainting = identifier;
                        this.setPage(Page.ADMIN_DELETE);
                    }
                }, (b, matrices, mx, my) -> this.func_243308_b(matrices, tooltip, mx, my))));
            }
        }
    }

    private void rebuildScreenshots() {
        int i;
        for (PaintingWidget w : this.paintingWidgetList) {
            this.field_230705_e_.remove((Object)w);
            this.field_230710_m_.remove((Object)w);
        }
        this.paintingWidgetList.clear();
        for (int x = 0; x < 5 && (i = x + this.screenshotPage * 5) >= 0 && i < this.screenshots.size(); ++x) {
            File file = this.screenshots.get(i);
            Painting painting = new Painting(null, 16, 16, 16, false);
            this.paintingWidgetList.add((PaintingWidget)this.func_230480_a_((Widget)new PaintingWidget(painting.thumbnail, this.field_230708_k_ / 2 + (x - 2) * 68 - 32, this.field_230709_l_ / 2 + 15, 64, 48, b -> {
                this.currentImage = ((PaintingWidget)b).thumbnail.image;
                if (this.currentImage != null) {
                    currentImagePixelZoomCache = -1;
                    this.currentImageName = file.getName();
                    this.settings = new PixelatorSettings(this.currentImage);
                    this.setPage(Page.CREATE);
                    this.pixelateImage();
                }
            }, b -> {}, (b, matrices, mx, my) -> this.func_238652_a_(matrices, (ITextComponent)new StringTextComponent(file.getName()), mx, my))));
            ResourceLocation identifier = Main.locate("screenshot_" + x);
            Runnable task = () -> {
                ByteImage image = this.loadImage(file.getPath(), identifier);
                if (image != null) {
                    painting.width = image.getWidth();
                    painting.height = image.getHeight();
                    painting.thumbnail.image = image;
                    painting.thumbnail.textureIdentifier = identifier;
                }
            };
            this.service.submit(task);
        }
    }

    public void setPage(Page page) {
        this.page = page;
        this.error = null;
        this.filteredResolution = page == Page.DATAPACKS ? 32 : 0;
        this.rebuild();
        if (page == Page.DATAPACKS || page == Page.PLAYERS || page == Page.YOURS) {
            this.updateSearch();
        }
    }

    private void updateSearch() {
        this.filteredPaintings.clear();
        String playerName = this.getPlayerName();
        this.filteredPaintings.addAll(ClientPaintingManager.getPaintings().entrySet().stream().filter(v -> this.page != Page.YOURS || Objects.equals(((Painting)v.getValue()).author, playerName) && !((Painting)v.getValue()).datapack).filter(v -> this.page != Page.PLAYERS || !Objects.equals(((Painting)v.getValue()).author, playerName) && !((Painting)v.getValue()).datapack && !((Painting)v.getValue()).hidden).filter(v -> this.page != Page.DATAPACKS || ((Painting)v.getValue()).datapack).filter(v -> ((ResourceLocation)v.getKey()).toString().contains(this.filteredString)).filter(v -> this.filteredResolution == 0 || ((Painting)v.getValue()).resolution == this.filteredResolution).filter(v -> this.filteredWidth == 0 || ((Painting)v.getValue()).width == this.filteredWidth).filter(v -> this.filteredHeight == 0 || ((Painting)v.getValue()).height == this.filteredHeight).map(Map.Entry::getKey).collect(Collectors.toList()));
        this.setSelectionPage(this.selectionPage);
    }

    private String getPlayerName() {
        return Minecraft.func_71410_x().field_71439_g == null ? "" : Minecraft.func_71410_x().field_71439_g.func_146103_bH().getName();
    }

    private boolean isOp() {
        return Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_211513_k(4);
    }

    private void setSelectionPage(int p) {
        this.selectionPage = Math.min(this.getMaxPages() - 1, Math.max(0, p));
        this.rebuildPaintings();
        this.pageWidget.func_238482_a_((ITextComponent)new StringTextComponent(this.selectionPage + 1 + " / " + this.getMaxPages()));
    }

    private int getMaxPages() {
        return (int)Math.ceil((double)this.filteredPaintings.size() / 24.0);
    }

    private void setScreenshotPage(int p) {
        int oldPage = this.screenshotPage;
        this.screenshotPage = Math.min(this.getScreenshotMaxPages() - 1, Math.max(0, p));
        if (oldPage != this.screenshotPage) {
            this.rebuildScreenshots();
        }
        this.pageWidget.func_238482_a_((ITextComponent)new StringTextComponent(this.screenshotPage + 1 + " / " + this.getScreenshotMaxPages()));
    }

    private int getScreenshotMaxPages() {
        return (int)Math.ceil((double)this.screenshots.size() / 8.0);
    }

    public void func_230476_a_(List<Path> paths) {
        Path path = paths.get(0);
        this.loadImage(path.toString());
    }

    private void loadImage(String path) {
        this.currentImage = this.loadImage(path, Main.locate("temp"));
        currentImagePixelZoomCache = -1;
        if (this.currentImage != null) {
            this.currentImageName = FilenameUtils.getBaseName((String)path).replaceFirst("[.][^.]+$", "");
            this.settings = new PixelatorSettings(this.currentImage);
            this.setPage(Page.CREATE);
            this.pixelateImage();
        }
    }

    private ByteImage loadImage(String path, ResourceLocation identifier) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stream != null) {
            try {
                ByteImage nativeImage = ByteImage.read(stream);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(identifier, (Texture)new DynamicTexture(ClientUtils.byteImageToNativeImage(nativeImage)));
                stream.close();
                return nativeImage;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static int getCurrentImagePixelZoomCache(ByteImage currentImage) {
        if (currentImagePixelZoomCache < 0) {
            currentImagePixelZoomCache = ImageManipulations.scanForPixelArtMultiple(currentImage);
        }
        return currentImagePixelZoomCache;
    }

    private void pixelateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
        shouldUpload = true;
    }

    private void adaptToPixelArt() {
        double zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(this.currentImage);
        this.settings.width = Math.max(1, Math.min(16, (int)((double)this.currentImage.getWidth() / zoom / (double)this.settings.resolution)));
        this.settings.height = Math.max(1, Math.min(16, (int)((double)this.currentImage.getHeight() / zoom / (double)this.settings.resolution)));
    }

    public static ByteImage pixelateImage(ByteImage currentImage, PixelatorSettings settings) {
        double zoom;
        ByteImage pixelatedImage = new ByteImage(settings.resolution * settings.width, settings.resolution * settings.height);
        if (settings.pixelArt) {
            zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(currentImage);
        } else {
            float fx = (float)currentImage.getWidth() / (float)pixelatedImage.getWidth();
            float fy = (float)currentImage.getHeight() / (float)pixelatedImage.getHeight();
            zoom = (double)Math.min(fx, fy) / settings.zoom;
        }
        int ox = (int)(((double)currentImage.getWidth() - (double)pixelatedImage.getWidth() * zoom) * settings.offsetX);
        int oy = (int)(((double)currentImage.getHeight() - (double)pixelatedImage.getHeight() * zoom) * settings.offsetY);
        if (settings.pixelArt) {
            ox = ox / (int)zoom * (int)zoom;
            oy = oy / (int)zoom * (int)zoom;
        }
        ImageManipulations.resize(pixelatedImage, currentImage, zoom, ox, oy);
        if (settings.dither > 0.0 && !settings.pixelArt) {
            if (settings.colors > 1) {
                ImageManipulations.dither(pixelatedImage, settings.dither / (double)settings.colors);
            } else {
                ImageManipulations.dither(pixelatedImage, settings.dither / 16.0);
            }
        }
        if (settings.colors > 1 && !settings.pixelArt) {
            ImageManipulations.reduceColors(pixelatedImage, settings.colors);
        }
        return pixelatedImage;
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void setError(TranslationTextComponent text) {
        this.error = text;
    }

    private /* synthetic */ void lambda$rebuild$20(Double v) {
        this.settings.zoom = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$15(Double v) {
        this.settings.dither = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$14(Integer v) {
        this.settings.colors = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$3(Page page, Button sender) {
        this.setPage(page);
    }

    static {
        currentImagePixelZoomCache = -1;
    }

    public static enum Page {
        YOURS,
        DATAPACKS,
        PLAYERS,
        NEW,
        CREATE,
        FRAME,
        DELETE,
        ADMIN_DELETE,
        LOADING;

    }

    public static final class PixelatorSettings {
        public double dither;
        public int colors;
        public int resolution;
        public int width;
        public int height;
        public double offsetX;
        public double offsetY;
        public double zoom;
        public boolean pixelArt;
        public boolean hidden;

        public PixelatorSettings(double dither, int colors, int resolution, int width, int height, double offsetX, double offsetY, double zoom, boolean pixelArt) {
            this.dither = dither;
            this.colors = colors;
            this.resolution = resolution;
            this.width = width;
            this.height = height;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.zoom = zoom;
            this.pixelArt = pixelArt;
        }

        PixelatorSettings(ByteImage currentImage) {
            this(0.25, 10, 32, 1, 1, 0.5, 0.5, 1.0, false);
            double target = (double)currentImage.getWidth() / (double)currentImage.getHeight();
            double bestScore = 100.0;
            double d = Math.sqrt(currentImage.getWidth() * currentImage.getWidth() + currentImage.getHeight() * currentImage.getHeight());
            double dw = (double)currentImage.getWidth() / d;
            double dh = (double)currentImage.getHeight() / d;
            float diagonal = 3.0f;
            while ((double)diagonal < 6.0) {
                int ph;
                int pw = (int)Math.ceil(dw * (double)diagonal);
                double e = Math.abs((double)pw / (double)(ph = (int)Math.ceil(dh * (double)diagonal)) - target) * Math.sqrt(5 + this.width + this.height);
                if (e < bestScore) {
                    this.width = pw;
                    this.height = ph;
                    bestScore = e;
                }
                diagonal = (float)((double)diagonal + target);
            }
        }
    }
}

