/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.util.registry;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.common.dispenser.SpawnEggDispenseBehavior;
import com.minecraftabnormals.abnormals_core.common.items.AbnormalsBoatItem;
import com.minecraftabnormals.abnormals_core.common.items.AbnormalsSpawnEggItem;
import com.minecraftabnormals.abnormals_core.common.items.FuelItem;
import com.minecraftabnormals.abnormals_core.core.registry.BoatRegistry;
import com.minecraftabnormals.abnormals_core.core.util.registry.AbstractSubRegistryHelper;
import com.minecraftabnormals.abnormals_core.core.util.registry.RegistryHelper;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TallBlockItem;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemSubRegistryHelper
extends AbstractSubRegistryHelper<Item> {
    private static final Field EGGS_FIELD = ObfuscationReflectionHelper.findField(SpawnEggItem.class, (String)"field_195987_b");
    protected final Set<AbnormalsSpawnEggItem> spawnEggs = Sets.newHashSet();

    public ItemSubRegistryHelper(RegistryHelper parent, DeferredRegister<Item> deferredRegister) {
        super(parent, deferredRegister);
    }

    public ItemSubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)parent.getModId()));
    }

    public <I extends Item> RegistryObject<I> createItem(String name, Supplier<? extends I> supplier) {
        return this.deferredRegister.register(name, supplier);
    }

    public RegistryObject<Item> createCompatItem(String modId, String name, Item.Properties properties, ItemGroup group) {
        return this.deferredRegister.register(name, () -> new Item(properties.func_200916_a((ItemGroup)(ModList.get().isLoaded(modId) || modId == "indev" ? group : null))));
    }

    public RegistryObject<Item> createCompatItem(String name, Item.Properties properties, ItemGroup group, String ... modIds) {
        return this.deferredRegister.register(name, () -> new Item(properties.func_200916_a((ItemGroup)(ItemSubRegistryHelper.areModsLoaded(modIds) ? group : null))));
    }

    public RegistryObject<AbnormalsSpawnEggItem> createSpawnEggItem(String entityName, Supplier<EntityType<?>> supplier, int primaryColor, int secondaryColor) {
        AbnormalsSpawnEggItem eggItem = new AbnormalsSpawnEggItem(supplier, primaryColor, secondaryColor, new Item.Properties().func_200916_a(ItemGroup.field_78026_f));
        RegistryObject spawnEgg = this.deferredRegister.register(entityName + "_spawn_egg", () -> eggItem);
        this.spawnEggs.add(eggItem);
        return spawnEgg;
    }

    public RegistryObject<Item> createBoatItem(String wood, RegistryObject<Block> block) {
        String type = this.parent.getModId() + ":" + wood;
        RegistryObject boat = this.deferredRegister.register(wood + "_boat", () -> new AbnormalsBoatItem(type, ItemSubRegistryHelper.createSimpleItemProperty(1, ItemGroup.field_78029_e)));
        BoatRegistry.registerBoat(type, (RegistryObject<Item>)boat, block);
        return boat;
    }

    public static BlockItem createWallOrFloorItem(Block floorBlock, Block wallBlock, ItemGroup itemGroup) {
        return new WallOrFloorItem(floorBlock, wallBlock, new Item.Properties().func_200916_a(itemGroup));
    }

    public static BlockItem createTallBlockItem(Block blockForInput, ItemGroup itemGroup) {
        return new TallBlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup));
    }

    public static FuelItem createFuelItem(int burnTime, ItemGroup itemGroup) {
        return new FuelItem(burnTime, new Item.Properties().func_200916_a(itemGroup));
    }

    public static BlockItem createSimpleBlockItem(Block blockForInput, @Nullable ItemGroup itemGroup) {
        return new BlockItem(blockForInput, new Item.Properties().func_200916_a(itemGroup));
    }

    public static Item.Properties createSimpleItemProperty(int stackSize, ItemGroup itemGroup) {
        return new Item.Properties().func_200916_a(itemGroup).func_200917_a(stackSize);
    }

    @Override
    public void register(IEventBus eventBus) {
        super.register(eventBus);
        eventBus.addGenericListener(EntityType.class, EventPriority.LOWEST, this::handleSpawnEggMap);
        eventBus.addListener(EventPriority.LOWEST, this::handleSpawnEggDispenserBehaviors);
    }

    private void handleSpawnEggMap(RegistryEvent.Register<EntityType<?>> event) {
        if (!this.spawnEggs.isEmpty()) {
            try {
                Map map = (Map)EGGS_FIELD.get(null);
                this.spawnEggs.forEach(egg -> {
                    SpawnEggItem cfr_ignored_0 = map.put(egg.func_208076_b(null), egg);
                });
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleSpawnEggDispenserBehaviors(FMLCommonSetupEvent event) {
        if (!this.spawnEggs.isEmpty()) {
            event.enqueueWork(() -> {
                for (AbnormalsSpawnEggItem spawnEggItem : this.spawnEggs) {
                    DispenserBlock.func_199774_a((IItemProvider)spawnEggItem, (IDispenseItemBehavior)new SpawnEggDispenseBehavior());
                }
            });
        }
    }
}

