/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.events;

import com.minecraftabnormals.abnormals_core.core.api.IAgeableEntity;
import com.minecraftabnormals.abnormals_core.core.config.ACConfig;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.abnormals_core.core.util.NetworkUtil;
import java.util.List;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="abnormals_core")
public final class CompatEvents {
    public static final String POISON_TAG = "abnormals_core:poisoned_by_potato";
    public static final String NOTE_KEY = "minecraft:note";
    public static List<DataUtil.CustomNoteBlockInstrument> SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS = null;

    @SubscribeEvent
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        ItemStack stack = event.getItemStack();
        if (target instanceof IAgeableEntity && ((IAgeableEntity)target).hasGrowthProgress() && stack.func_77973_b() == Items.field_151170_bI && ACConfig.ValuesHolder.isPoisonPotatoCompatEnabled() && ModList.get().isLoaded("quark")) {
            PlayerEntity player = event.getPlayer();
            CompoundNBT persistentData = target.getPersistentData();
            if (((IAgeableEntity)target).canAge(true) && !persistentData.func_74767_n(POISON_TAG)) {
                if (target.field_70170_p.field_73012_v.nextDouble() < ACConfig.ValuesHolder.poisonEffectChance()) {
                    target.func_184185_a(SoundEvents.field_187537_bA, 0.5f, 0.25f);
                    persistentData.func_74757_a(POISON_TAG, true);
                    if (ACConfig.ValuesHolder.shouldPoisonEntity()) {
                        ((LivingEntity)target).func_195064_c(new EffectInstance(Effects.field_76436_u, 200));
                    }
                } else {
                    target.func_184185_a(SoundEvents.field_187537_bA, 0.5f, 0.5f + target.field_70170_p.field_73012_v.nextFloat() / 2.0f);
                }
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                event.setCancellationResult(ActionResultType.func_233537_a_((boolean)event.getWorld().func_201670_d()));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onUpdateEntity(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof IAgeableEntity && ACConfig.ValuesHolder.isPoisonPotatoCompatEnabled() && ModList.get().isLoaded("quark") && entity.getPersistentData().func_74767_n(POISON_TAG)) {
            ((IAgeableEntity)entity).resetGrowthProgress();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onNoteBlockPlay(NoteBlockEvent.Play event) {
        World world;
        if (SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS != null && !(world = (World)event.getWorld()).func_201670_d()) {
            BlockPos pos = event.getPos();
            ProxyBlockSource source = new ProxyBlockSource((ServerWorld)world, pos.func_177972_a(Direction.DOWN));
            for (DataUtil.CustomNoteBlockInstrument instrument : SORTED_CUSTOM_NOTE_BLOCK_INSTRUMENTS) {
                if (!instrument.test((IBlockSource)source)) continue;
                SoundEvent sound = instrument.getSound();
                double note = event.getVanillaNoteId();
                world.func_184133_a(null, pos, sound, SoundCategory.RECORDS, 3.0f, (float)Math.pow(2.0, (note - 12.0) / 12.0));
                NetworkUtil.spawnParticle(NOTE_KEY, (RegistryKey<World>)world.func_234923_W_(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, note / 24.0, 0.0, 0.0);
                event.setCanceled(true);
                break;
            }
        }
    }
}

