/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.api.conditions.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.minecraftabnormals.abnormals_core.core.registry.ACLootConditions;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.registry.Registry;

public class RandomDifficultyChanceCondition
implements ILootCondition {
    private final float defaultChance;
    private final float peacefulChance;
    private final float easyChance;
    private final float normalChance;
    private final float hardChance;

    public RandomDifficultyChanceCondition(float defaultChance, float peacefulChance, float easyChance, float normalChance, float hardChance) {
        this.defaultChance = defaultChance;
        this.peacefulChance = peacefulChance;
        this.easyChance = easyChance;
        this.normalChance = normalChance;
        this.hardChance = hardChance;
    }

    public LootConditionType func_230419_b_() {
        return (LootConditionType)Registry.field_239704_ba_.func_82594_a(ACLootConditions.RANDOM_DIFFICULTY_CHANCE);
    }

    public boolean test(LootContext lootContext) {
        float chance = this.defaultChance;
        switch (lootContext.func_202879_g().func_175659_aa()) {
            case PEACEFUL: {
                if (!(this.peacefulChance >= 0.0f)) break;
                chance = this.peacefulChance;
                break;
            }
            case EASY: {
                if (!(this.easyChance >= 0.0f)) break;
                chance = this.easyChance;
                break;
            }
            case NORMAL: {
                if (!(this.normalChance >= 0.0f)) break;
                chance = this.normalChance;
                break;
            }
            case HARD: {
                if (!(this.hardChance >= 0.0f)) break;
                chance = this.hardChance;
            }
        }
        return lootContext.func_216032_b().nextFloat() < chance;
    }

    public static class Serializer
    implements ILootSerializer<RandomDifficultyChanceCondition> {
        public void serialize(JsonObject json, RandomDifficultyChanceCondition condition, JsonSerializationContext context) {
            json.addProperty("default_chance", (Number)Float.valueOf(condition.defaultChance));
            if (condition.peacefulChance >= 0.0f) {
                json.addProperty("peaceful", (Number)Float.valueOf(condition.peacefulChance));
            }
            if (condition.easyChance >= 0.0f) {
                json.addProperty("easy", (Number)Float.valueOf(condition.easyChance));
            }
            if (condition.normalChance >= 0.0f) {
                json.addProperty("normal", (Number)Float.valueOf(condition.normalChance));
            }
            if (condition.hardChance >= 0.0f) {
                json.addProperty("hard", (Number)Float.valueOf(condition.hardChance));
            }
        }

        public RandomDifficultyChanceCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (json.has("default_chance")) {
                return new RandomDifficultyChanceCondition(JSONUtils.func_151217_k((JsonObject)json, (String)"default_chance"), Serializer.getFloatOrMinus1(json, "peaceful"), Serializer.getFloatOrMinus1(json, "easy"), Serializer.getFloatOrMinus1(json, "normal"), Serializer.getFloatOrMinus1(json, "hard"));
            }
            throw new JsonSyntaxException("Missing 'default_chance', expected to find a float");
        }

        private static float getFloatOrMinus1(JsonObject json, String fieldName) {
            return json.has(fieldName) ? JSONUtils.func_151217_k((JsonObject)json, (String)fieldName) : -1.0f;
        }
    }
}

