/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.network.entity;

import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public final class MessageS2CTeleportEntity {
    private int entityId;
    private double posX;
    private double posY;
    private double posZ;

    public MessageS2CTeleportEntity(int entityID, double posX, double posY, double posZ) {
        this.entityId = entityID;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static MessageS2CTeleportEntity deserialize(PacketBuffer buf) {
        int entityId = buf.readInt();
        return new MessageS2CTeleportEntity(entityId, buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static void handle(MessageS2CTeleportEntity message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        Entity entity = ClientInfo.getClientPlayerWorld().func_73045_a(message.entityId);
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                if (entity != null) {
                    entity.func_70012_b(message.posX, message.posY, message.posZ, entity.field_70177_z, entity.field_70125_A);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

