/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.client.screen.shaking;

import com.minecraftabnormals.abnormals_core.client.screen.shaking.ShakeSource;
import com.minecraftabnormals.abnormals_core.core.config.ACConfig;
import com.minecraftabnormals.abnormals_core.core.mixin.client.ActiveRenderInfoInvokerMixin;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="abnormals_core", value={Dist.CLIENT})
public enum ScreenShakeHandler {
    INSTANCE;

    private static final Random RANDOM;
    private final List<ShakeSource> sources = new LinkedList<ShakeSource>();
    private double prevIntensityX;
    private double prevIntensityY;
    private double prevIntensityZ;
    private double intensityX;
    private double intensityY;
    private double intensityZ;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            INSTANCE.tick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        INSTANCE.shakeCamera(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        INSTANCE.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        INSTANCE.clear();
    }

    private static double randomizeIntensity(double intensity) {
        double randomDouble = RANDOM.nextDouble();
        return (1.0 - randomDouble * randomDouble) * ((double)RANDOM.nextInt(2) - 0.5) * intensity * 2.0;
    }

    public boolean addShakeSource(ShakeSource source) {
        List<ShakeSource> sources = this.sources;
        if (sources.size() >= ACConfig.ValuesHolder.getMaxScreenShakers()) {
            return false;
        }
        sources.add(source);
        return true;
    }

    private void tick() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!minecraft.func_147113_T()) {
            this.prevIntensityX = this.intensityX;
            this.prevIntensityY = this.intensityY;
            this.prevIntensityZ = this.intensityZ;
            List<ShakeSource> sources = this.sources;
            if (sources.isEmpty()) {
                this.intensityZ = 0.0;
                this.intensityY = 0.0;
                this.intensityX = 0.0;
            } else {
                Iterator<ShakeSource> sourceIterator = sources.iterator();
                Entity entity = minecraft.field_175622_Z;
                Vector3d pos = entity != null ? entity.func_213303_ch() : Vector3d.field_186680_a;
                double intensityX = 0.0;
                double intensityY = 0.0;
                double intensityZ = 0.0;
                while (sourceIterator.hasNext()) {
                    ShakeSource shakingSource = sourceIterator.next();
                    shakingSource.tick();
                    if (shakingSource.isStopped()) {
                        sourceIterator.remove();
                        continue;
                    }
                    Vector3d intensity = shakingSource.getIntensity(pos);
                    double newIntensityX = intensityX + intensity.field_72450_a;
                    double maxX = shakingSource.getMaxBuildupX();
                    if (newIntensityX <= maxX) {
                        intensityX = newIntensityX;
                    } else if (maxX > intensityX) {
                        intensityX = maxX;
                    }
                    double newIntensityY = intensityY + intensity.field_72448_b;
                    double maxY = shakingSource.getMaxBuildupY();
                    if (newIntensityY <= maxY) {
                        intensityY = newIntensityY;
                    } else if (maxY > intensityY) {
                        intensityY = maxY;
                    }
                    double newIntensityZ = intensityZ + intensity.field_72449_c;
                    double maxZ = shakingSource.getMaxBuildupZ();
                    if (newIntensityZ <= maxZ) {
                        intensityZ = newIntensityZ;
                        continue;
                    }
                    if (!(maxZ > intensityZ)) continue;
                    intensityZ = maxZ;
                }
                this.intensityX = intensityX != 0.0 ? ScreenShakeHandler.randomizeIntensity(intensityX) : 0.0;
                this.intensityY = intensityY != 0.0 ? ScreenShakeHandler.randomizeIntensity(intensityY) : 0.0;
                this.intensityZ = intensityZ != 0.0 ? ScreenShakeHandler.randomizeIntensity(intensityZ) : 0.0;
            }
        }
    }

    private void shakeCamera(EntityViewRenderEvent.CameraSetup event) {
        double screenEffectScale = ACConfig.ValuesHolder.getScreenShakeScale();
        if (screenEffectScale > 0.0) {
            double partialTicks = event.getRenderPartialTicks();
            double x = MathHelper.func_219803_d((double)partialTicks, (double)this.prevIntensityX, (double)this.intensityX);
            double y = MathHelper.func_219803_d((double)partialTicks, (double)this.prevIntensityY, (double)this.intensityY);
            double z = MathHelper.func_219803_d((double)partialTicks, (double)this.prevIntensityZ, (double)this.intensityZ);
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                ((ActiveRenderInfoInvokerMixin)event.getInfo()).callMove(z * screenEffectScale, y * screenEffectScale, x * screenEffectScale);
            }
        }
    }

    private void clear() {
        this.sources.clear();
        this.intensityZ = 0.0;
        this.intensityY = 0.0;
        this.intensityX = 0.0;
        this.prevIntensityZ = 0.0;
        this.prevIntensityY = 0.0;
        this.prevIntensityX = 0.0;
    }

    static {
        RANDOM = new Random();
    }
}

