/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.client.renderer;

import com.minecraftabnormals.abnormals_core.client.RewardHandler;
import com.minecraftabnormals.abnormals_core.client.model.SlabfishHatModel;
import com.minecraftabnormals.abnormals_core.common.world.storage.tracking.IDataManager;
import com.minecraftabnormals.abnormals_core.lib.sonar.sonar.client.util.OnlineImageCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;

public class SlabfishHatLayerRenderer
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static OnlineImageCache REWARD_CACHE = new OnlineImageCache("abnormals_core", 1L, TimeUnit.DAYS);
    private final SlabfishHatModel model;

    public SlabfishHatLayerRenderer(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer, SlabfishHatModel slabfishModel) {
        super(renderer);
        this.model = slabfishModel;
    }

    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, AbstractClientPlayerEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        RewardHandler.RewardProperties properties = RewardHandler.getRewardProperties();
        if (properties == null) {
            return;
        }
        RewardHandler.RewardProperties.SlabfishProperties slabfishProperties = properties.getSlabfishProperties();
        if (slabfishProperties == null) {
            return;
        }
        String defaultTypeUrl = slabfishProperties.getDefaultTypeUrl();
        IDataManager data = (IDataManager)entity;
        if (entity.func_82150_aj() || entity.func_175149_v() || !RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.ENABLED) || defaultTypeUrl == null || !RewardHandler.REWARDS.containsKey(entity.func_110124_au())) {
            return;
        }
        RewardHandler.RewardData reward = RewardHandler.REWARDS.get(entity.func_110124_au());
        if (reward.getSlabfish() == null || reward.getTier() < 2) {
            return;
        }
        RewardHandler.RewardData.SlabfishData slabfish = reward.getSlabfish();
        ResourceLocation typeLocation = REWARD_CACHE.getTextureLocation(reward.getTier() >= 4 && slabfish.getTypeUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.TYPE) ? slabfish.getTypeUrl() : defaultTypeUrl);
        if (typeLocation == null) {
            return;
        }
        ResourceLocation sweaterLocation = reward.getTier() >= 3 && slabfish.getSweaterUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.SWEATER) ? REWARD_CACHE.getTextureLocation(slabfish.getSweaterUrl()) : null;
        ResourceLocation backpackLocation = slabfish.getBackpackUrl() != null && RewardHandler.SlabfishSetting.getSetting(data, RewardHandler.SlabfishSetting.BACKPACK) ? REWARD_CACHE.getTextureLocation(slabfish.getBackpackUrl()) : null;
        ModelRenderer body = this.model.body;
        ModelRenderer backpack = this.model.backpack;
        body.func_217177_a(((PlayerModel)this.func_215332_c()).field_78116_c);
        body.func_228308_a_(stack, buffer.getBuffer(slabfish.isTranslucent() ? RenderType.func_228644_e_((ResourceLocation)typeLocation) : RenderType.func_228638_b_((ResourceLocation)typeLocation)), packedLight, OverlayTexture.field_229196_a_);
        if (sweaterLocation != null) {
            body.func_228308_a_(stack, buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)sweaterLocation)), packedLight, OverlayTexture.field_229196_a_);
        }
        if (backpackLocation != null) {
            backpack.func_217177_a(body);
            backpack.func_228308_a_(stack, buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)backpackLocation)), packedLight, OverlayTexture.field_229196_a_);
        }
    }
}

