/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.client.ClientEventsListener;
import top.theillusivec4.polymorph.client.PolymorphClientMod;
import top.theillusivec4.polymorph.common.CommonEventsListener;
import top.theillusivec4.polymorph.common.capability.FurnaceRecipeData;
import top.theillusivec4.polymorph.common.capability.PolymorphCapabilities;
import top.theillusivec4.polymorph.common.integration.PolymorphIntegrations;
import top.theillusivec4.polymorph.common.network.PolymorphNetwork;
import top.theillusivec4.polymorph.server.PolymorphCommands;

@Mod(value="polymorph")
public class PolymorphMod {
    public static final Logger LOGGER = LogManager.getLogger();

    public PolymorphMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        PolymorphIntegrations.init();
    }

    private void setup(FMLCommonSetupEvent pEvent) {
        PolymorphNetwork.setup();
        PolymorphCapabilities.register();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventsListener());
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.registerTileEntity2RecipeData(tileEntity -> {
            if (tileEntity instanceof AbstractFurnaceTileEntity) {
                return new FurnaceRecipeData((AbstractFurnaceTileEntity)tileEntity);
            }
            return null;
        });
        commonApi.registerContainer2TileEntity(container -> {
            for (Slot inventorySlot : container.field_75151_b) {
                IInventory inventory = inventorySlot.field_75224_c;
                if (!(inventory instanceof TileEntity)) continue;
                return (TileEntity)inventory;
            }
            return null;
        });
        PolymorphIntegrations.setup();
    }

    private void clientSetup(FMLClientSetupEvent pEvent) {
        PolymorphClientMod.setup();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventsListener());
        PolymorphIntegrations.clientSetup();
    }

    private void registerCommand(RegisterCommandsEvent pEvent) {
        PolymorphCommands.register((CommandDispatcher<CommandSource>)pEvent.getDispatcher());
    }
}

