/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.client.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import top.theillusivec4.polymorph.api.client.base.IPolymorphClient;
import top.theillusivec4.polymorph.api.client.base.IRecipesWidget;

public class PolymorphClient
implements IPolymorphClient {
    private static final IPolymorphClient INSTANCE = new PolymorphClient();
    private final List<IPolymorphClient.IRecipesWidgetFactory> widgetFactories = new LinkedList<IPolymorphClient.IRecipesWidgetFactory>();

    public static IPolymorphClient get() {
        return INSTANCE;
    }

    @Override
    public Optional<IRecipesWidget> getWidget(ContainerScreen<?> pContainerScreen) {
        for (IPolymorphClient.IRecipesWidgetFactory factory : this.widgetFactories) {
            IRecipesWidget widget = factory.createWidget(pContainerScreen);
            if (widget == null) continue;
            return Optional.of(widget);
        }
        return Optional.empty();
    }

    @Override
    public void registerWidget(IPolymorphClient.IRecipesWidgetFactory pFactory) {
        this.widgetFactories.add(pFactory);
    }

    @Override
    public Optional<Slot> findCraftingResultSlot(ContainerScreen<?> pContainerScreen) {
        Container container = pContainerScreen.func_212873_a_();
        for (Slot slot : container.field_75151_b) {
            if (!(slot.field_75224_c instanceof CraftResultInventory)) continue;
            return Optional.of(slot);
        }
        return Optional.empty();
    }
}

