/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api.client.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.client.gui.GuiUtils;
import top.theillusivec4.polymorph.api.client.widget.OutputWidget;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;

public class SelectionWidget
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    private final Consumer<ResourceLocation> onSelect;
    private final ContainerScreen<?> containerScreen;
    private final List<OutputWidget> outputWidgets = new ArrayList<OutputWidget>();
    private int xOffset;
    private int yOffset;
    private OutputWidget hoveredButton;
    private boolean active = false;
    private int x;
    private int y;
    private int lastX;
    private int lastY;

    public SelectionWidget(int pX, int pY, int pXOffset, int pYOffset, Consumer<ResourceLocation> pOnSelect, ContainerScreen<?> pContainerScreen) {
        this.setPosition(pX, pY);
        this.onSelect = pOnSelect;
        this.containerScreen = pContainerScreen;
        this.xOffset = pXOffset;
        this.yOffset = pYOffset;
    }

    public void setPosition(int pX, int pY) {
        this.x = pX;
        this.y = pY;
        this.updateButtonPositions();
    }

    public void setOffsets(int pX, int pY) {
        this.xOffset = pX;
        this.yOffset = pY;
    }

    public void highlightButton(ResourceLocation pResourceLocation) {
        this.outputWidgets.forEach(widget -> widget.setHighlighted(widget.getResourceLocation().equals((Object)pResourceLocation)));
    }

    private void updateButtonPositions() {
        int size = this.outputWidgets.size();
        int xOffset = (int)(-25.0 * Math.floor((float)size / 2.0f));
        if (size % 2 == 0) {
            xOffset += 13;
        }
        int[] pos = new int[]{this.x + xOffset, this.y};
        this.outputWidgets.forEach(widget -> {
            widget.setPosition(pos[0], pos[1]);
            pos[0] = pos[0] + 25;
        });
    }

    public List<OutputWidget> getOutputWidgets() {
        return this.outputWidgets;
    }

    public void setRecipeList(Set<IRecipePair> pRecipeList) {
        this.outputWidgets.clear();
        pRecipeList.forEach(data -> {
            if (!data.getOutput().func_190926_b()) {
                this.outputWidgets.add(new OutputWidget((IRecipePair)data));
            }
        });
        this.updateButtonPositions();
    }

    public void setActive(boolean pActive) {
        this.active = pActive;
    }

    public boolean isActive() {
        return this.active;
    }

    public void renderTooltip(MatrixStack pMatrixStack, int pMouseX, int pMouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && this.hoveredButton != null) {
            this.renderTooltip(this.hoveredButton.getOutput(), pMatrixStack, this.hoveredButton.getTooltipText(mc.field_71462_r), pMouseX, pMouseY);
        }
    }

    public void func_230430_a_(@Nonnull MatrixStack pMatrixStack, int pMouseX, int pMouseY, float pPartialTicks) {
        if (this.isActive()) {
            int x = this.containerScreen.getGuiLeft() + this.xOffset;
            int y = this.containerScreen.getGuiTop() + this.yOffset;
            if (this.lastX != x || this.lastY != y) {
                this.setPosition(x, y);
                this.lastX = x;
                this.lastY = y;
            }
            this.hoveredButton = null;
            this.outputWidgets.forEach(button -> {
                button.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pPartialTicks);
                if (button.field_230694_p_ && button.func_230449_g_()) {
                    this.hoveredButton = button;
                }
            });
            this.renderTooltip(pMatrixStack, pMouseX, pMouseY);
        }
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        if (this.isActive()) {
            for (OutputWidget widget : this.outputWidgets) {
                if (!widget.func_231044_a_(pMouseX, pMouseY, pButton)) continue;
                this.onSelect.accept(widget.getResourceLocation());
                return true;
            }
        }
        return false;
    }

    public void renderTooltip(ItemStack pStack, MatrixStack pMatrixStack, List<ITextComponent> pText, int pMouseX, int pMouseY) {
        SelectionWidget.drawHoveringText(pStack, pMatrixStack, pText, pMouseX, pMouseY, this.containerScreen.field_230708_k_, this.containerScreen.field_230709_l_, -1, -267386864, 0x505000FF, 1344798847, this.containerScreen.getMinecraft().field_71466_p);
    }

    public static void drawHoveringText(@Nonnull ItemStack pStack, MatrixStack pMatrixStack, List<? extends ITextProperties> pText, int pMouseX, int pMouseY, int pScreenWidth, int pScreenHeight, int pMaxTextWidth, int pBackgroundColor, int pBorderColorStart, int pBorderColorEnd, FontRenderer pFontRenderer) {
        if (!pText.isEmpty()) {
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(pStack, pText, pMatrixStack, pMouseX, pMouseY, pScreenWidth, pScreenHeight, pMaxTextWidth, pFontRenderer);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            pMouseX = event.getX();
            pMouseY = event.getY();
            pScreenWidth = event.getScreenWidth();
            pScreenHeight = event.getScreenHeight();
            pMaxTextWidth = event.getMaxWidth();
            pFontRenderer = event.getFontRenderer();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            int tooltipTextWidth = 0;
            for (ITextProperties iTextProperties : pText) {
                int textLineWidth = pFontRenderer.func_238414_a_(iTextProperties);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = pMouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > pScreenWidth && (tooltipX = pMouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = pMouseX > pScreenWidth / 2 ? pMouseX - 12 - 8 : pScreenWidth - 16 - pMouseX;
                needsWrap = true;
            }
            if (pMaxTextWidth > 0 && tooltipTextWidth > pMaxTextWidth) {
                tooltipTextWidth = pMaxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends ITextProperties> wrappedTextLines = new ArrayList<ITextProperties>();
                for (int i = 0; i < pText.size(); ++i) {
                    ITextProperties textLine = pText.get(i);
                    List wrappedLine = pFontRenderer.func_238420_b_().func_238362_b_(textLine, tooltipTextWidth, Style.field_240709_b_);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (ITextProperties line : wrappedLine) {
                        int lineWidth = pFontRenderer.func_238414_a_(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((ITextProperties)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                pText = wrappedTextLines;
                tooltipX = pMouseX > pScreenWidth / 2 ? pMouseX - 16 - tooltipTextWidth : pMouseX + 12;
            }
            int tooltipY = pMouseY - 12;
            int tooltipHeight = 8;
            if (pText.size() > 1) {
                tooltipHeight += (pText.size() - 1) * 10;
                if (pText.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > pScreenHeight) {
                tooltipY = pScreenHeight - tooltipHeight - 4;
            }
            int zLevel = 901;
            RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(pStack, pText, pMatrixStack, tooltipX, tooltipY, pFontRenderer, pBackgroundColor, pBorderColorStart, pBorderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            pBackgroundColor = colorEvent.getBackground();
            pBorderColorStart = colorEvent.getBorderStart();
            pBorderColorEnd = colorEvent.getBorderEnd();
            pMatrixStack.func_227860_a_();
            Matrix4f mat = pMatrixStack.func_227866_c_().func_227870_a_();
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 3), (int)(tooltipY - 4), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)pBackgroundColor, (int)pBackgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 4), (int)pBackgroundColor, (int)pBackgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)pBackgroundColor, (int)pBackgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 4), (int)(tooltipY - 3), (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 3), (int)pBackgroundColor, (int)pBackgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 4), (int)(tooltipY + tooltipHeight + 3), (int)pBackgroundColor, (int)pBackgroundColor);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 3), (int)(tooltipY - 3 + 1), (int)(tooltipX - 3 + 1), (int)(tooltipY + tooltipHeight + 3 - 1), (int)pBorderColorStart, (int)pBorderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX + tooltipTextWidth + 2), (int)(tooltipY - 3 + 1), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3 - 1), (int)pBorderColorStart, (int)pBorderColorEnd);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 3), (int)(tooltipY - 3), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY - 3 + 1), (int)pBorderColorStart, (int)pBorderColorStart);
            GuiUtils.drawGradientRect((Matrix4f)mat, (int)901, (int)(tooltipX - 3), (int)(tooltipY + tooltipHeight + 2), (int)(tooltipX + tooltipTextWidth + 3), (int)(tooltipY + tooltipHeight + 3), (int)pBorderColorEnd, (int)pBorderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(pStack, pText, pMatrixStack, tooltipX, tooltipY, pFontRenderer, tooltipTextWidth, tooltipHeight));
            IRenderTypeBuffer.Impl renderType = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            pMatrixStack.func_227861_a_(0.0, 0.0, 901.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < pText.size(); ++lineNumber) {
                ITextProperties line = pText.get(lineNumber);
                if (line != null) {
                    pFontRenderer.func_238416_a_(LanguageMap.func_74808_a().func_241870_a(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (IRenderTypeBuffer)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.func_228461_a_();
            pMatrixStack.func_227865_b_();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(pStack, pText, pMatrixStack, tooltipX, tooltipTop, pFontRenderer, tooltipTextWidth, tooltipHeight));
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }
}

