/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.tileentity.interfaces;

import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface INBTTunnel {

    public static interface BlockEntity {
        public CompoundNBT getData();

        public void clearData();
    }

    public static interface Block {
        public static Optional<BlockEntity> tryGetBlockEntity(World world, BlockPos pos) {
            TileEntity blockEntity = world.func_175625_s(pos);
            if (!(blockEntity instanceof BlockEntity)) {
                return Optional.empty();
            }
            return Optional.of((BlockEntity)blockEntity);
        }

        default public boolean tryPullDataUp(World world, BlockPos pos) {
            Optional<BlockEntity> blockEntityBelow = Block.tryGetBlockEntity(world, pos.func_177977_b());
            Optional<BlockEntity> blockEntity = Block.tryGetBlockEntity(world, pos);
            if (!blockEntityBelow.isPresent() || !blockEntity.isPresent()) {
                return false;
            }
            BlockEntity source = blockEntityBelow.get();
            BlockEntity destination = blockEntity.get();
            destination.clearData();
            destination.getData().func_197643_a(source.getData());
            return true;
        }

        default public void tryClearData(World world, BlockPos pos) {
            Block.tryGetBlockEntity(world, pos).ifPresent(BlockEntity::clearData);
        }

        public static Optional<CompoundNBT> tryGetData(World world, BlockPos pos) {
            return Block.tryGetBlockEntity(world, pos).map(BlockEntity::getData);
        }
    }
}

