/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.tileentity;

import dev.falsegamemaster.ihatecores.registration.block_entities.IHasCustomTileRenderer;
import dev.sam.signs_and_signals.client.renderer.tileentity.SignPostRenderer;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SignPostBlockEntity
extends TileEntity
implements IHasCustomTileRenderer<SignPostBlockEntity>,
ITickableTileEntity {
    protected Block signBlock = null;

    public SignPostBlockEntity(TileEntityType<?> type) {
        super(type);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.loadSignBlock(nbt);
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        this.saveSignBlock(nbt);
        return super.func_189515_b(nbt);
    }

    protected void loadSignBlock(CompoundNBT nbt) {
        String name = nbt.func_74779_i("SignBlock");
        if (name.equals("")) {
            return;
        }
        this.signBlock = (Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(name));
    }

    protected void saveSignBlock(CompoundNBT nbt) {
        if (this.signBlock == null) {
            return;
        }
        ResourceLocation loc = this.signBlock.getRegistryName();
        if (loc == null) {
            return;
        }
        nbt.func_74778_a("SignBlock", loc.toString());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.saveSignBlock(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, nbt);
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        CompoundNBT nbt = packet.func_148857_g();
        this.loadSignBlock(nbt);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
        BlockState state = this.func_195044_w();
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, chunk, state, state, 2, 0);
    }

    public Optional<Block> getSignBlock() {
        return Optional.ofNullable(this.signBlock);
    }

    public void setSignBlock(@Nullable Block signBlock, boolean notify) {
        this.signBlock = signBlock;
        if (this.field_145850_b == null || !notify) {
            return;
        }
        this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, this.func_195044_w(), this.func_195044_w(), 2, 0);
    }

    public NonNullList<ItemStack> getDrops() {
        NonNullList drops = NonNullList.func_191196_a();
        this.getSignBlock().ifPresent(signBlock -> drops.add((Object)new ItemStack((IItemProvider)signBlock)));
        return drops;
    }

    protected void dropSign() {
        if (this.field_145850_b == null) {
            return;
        }
        InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, this.getDrops());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.dropSign();
    }

    public TileEntityRenderer<SignPostBlockEntity> createRenderer(Supplier<TileEntityRendererDispatcher> dispatcher) {
        return (TileEntityRenderer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> SignPostBlockEntity.lambda$null$1((Supplier)dispatcher));
    }

    public double func_145833_n() {
        return ((Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().field_71474_y.field_151451_c * 16)).intValue();
    }

    private static /* synthetic */ SignPostRenderer lambda$null$1(Supplier dispatcher) throws Exception {
        return new SignPostRenderer((TileEntityRendererDispatcher)dispatcher.get());
    }
}

