/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.item;

import dev.sam.keys_and_leds_core.util.SafeBlockState;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.state.properties.ModBlockStateProperties;
import dev.sam.signs_and_signals.stats.ModStats;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CrossingLightItem
extends BlockItem {
    protected final Block field_150939_a;
    protected final Supplier<Block> crossingLightsBlock;

    public CrossingLightItem(Block block, Supplier<Block> crossingLightsBlock, Item.Properties properties) {
        super(block, properties);
        this.crossingLightsBlock = crossingLightsBlock;
        this.field_150939_a = block;
    }

    protected boolean directionsEqual(BlockState oldState, BlockState newState) {
        SafeBlockState safeOldState = SafeBlockState.of((BlockState)oldState);
        SafeBlockState safeNewState = SafeBlockState.of((BlockState)newState);
        boolean oldNorth = safeOldState.getValue((Property)BlockStateProperties.field_208151_D).orElse(false);
        boolean oldEast = safeOldState.getValue((Property)BlockStateProperties.field_208152_E).orElse(false);
        boolean oldSouth = safeOldState.getValue((Property)BlockStateProperties.field_208153_F).orElse(false);
        boolean oldWest = safeOldState.getValue((Property)BlockStateProperties.field_208154_G).orElse(false);
        boolean newNorth = safeNewState.getValue((Property)BlockStateProperties.field_208151_D).orElse(false);
        boolean newEast = safeNewState.getValue((Property)BlockStateProperties.field_208152_E).orElse(false);
        boolean newSouth = safeNewState.getValue((Property)BlockStateProperties.field_208153_F).orElse(false);
        boolean newWest = safeNewState.getValue((Property)BlockStateProperties.field_208154_G).orElse(false);
        boolean northsEqual = oldNorth == newNorth;
        boolean eastsEqual = oldEast == newEast;
        boolean southsEqual = oldSouth == newSouth;
        boolean westsEqual = oldWest == newWest;
        return northsEqual && eastsEqual && southsEqual && westsEqual;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Block postBlock = (Block)SignsAndSignals.BLOCKS.get("steel_post");
        Block crossingLightsBlock = this.crossingLightsBlock.get();
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.CONSUME;
        }
        if (!block.func_235332_a_(postBlock) && !block.func_235332_a_(crossingLightsBlock)) {
            player.func_195066_a(ModStats.SIGNALS_PLACED);
            return super.func_195939_a(context);
        }
        Direction direction = context.func_195992_f();
        DirectionalPlaceContext signalPostContext = new DirectionalPlaceContext(world, pos, direction, context.func_195996_i(), direction);
        BlockState signalPostState = crossingLightsBlock.func_196258_a((BlockItemUseContext)signalPostContext);
        if (signalPostState == null || this.directionsEqual(state, signalPostState)) {
            return super.func_195939_a(context);
        }
        boolean north = (Boolean)signalPostState.func_177229_b((Property)BlockStateProperties.field_208151_D);
        boolean south = (Boolean)signalPostState.func_177229_b((Property)BlockStateProperties.field_208153_F);
        if (block.func_235332_a_(postBlock) && (north || south)) {
            signalPostState = (BlockState)signalPostState.func_206870_a((Property)ModBlockStateProperties.X_TOP, (Comparable)Boolean.valueOf(true));
        }
        world.func_175656_a(pos, signalPostState);
        if (!player.func_184812_l_()) {
            context.func_195996_i().func_190918_g(1);
        }
        player.func_195066_a(ModStats.SIGNALS_PLACED);
        return ActionResultType.CONSUME;
    }
}

