/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.inventory.container.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.falsegamemaster.ihatecores.registration.containers.screens.GenericContainerScreen;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.inventory.container.SignWorkbenchContainer;
import dev.sam.signs_and_signals.packet.SignWorkbenchScrollPacket;
import dev.sam.signs_and_signals.recipe.SignWorkbenchRecipe;
import java.awt.Rectangle;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SignWorkbenchScreen
extends GenericContainerScreen<SignWorkbenchContainer> {
    protected final ResourceLocation background;
    protected boolean isScrolling = false;
    protected int scrollButtonY;
    protected SignWorkbenchRecipe recipe;

    public SignWorkbenchScreen(String modid, String name, SignWorkbenchContainer container, PlayerInventory playerInv, ITextComponent title) {
        super(modid, name, (Container)container, playerInv, title);
        this.background = new ResourceLocation(modid, "textures/gui/container/" + name + ".png");
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.scrollButtonY = this.field_147009_r + 17;
        this.field_238743_q_ -= 2;
    }

    protected Optional<SignWorkbenchRecipe> getRecipe() {
        return Optional.ofNullable(this.recipe);
    }

    protected Optional<SignWorkbenchRecipe> craftRecipe() {
        Optional<SignWorkbenchRecipe> recipe = ((SignWorkbenchContainer)this.field_147002_h).tryGetSelectedRecipe();
        recipe.ifPresent(r -> {
            this.recipe = r;
        });
        return recipe;
    }

    protected void renderSlotBackgrounds(MatrixStack stack) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        if (!((SignWorkbenchContainer)this.field_147002_h).getSlot("sheet").func_75216_d()) {
            this.func_238474_b_(stack, i + 17, j + 17, this.field_146999_f, 0, 16, 16);
        }
        if (!((SignWorkbenchContainer)this.field_147002_h).getSlot("snips").func_75216_d()) {
            this.func_238474_b_(stack, i + 35, j + 17, this.field_146999_f + 16, 0, 16, 16);
        }
        if (!((SignWorkbenchContainer)this.field_147002_h).getSlot("dye_top_left").func_75216_d()) {
            this.func_238474_b_(stack, i + 17, j + 35, this.field_146999_f + 32, 0, 16, 16);
        }
        if (!((SignWorkbenchContainer)this.field_147002_h).getSlot("dye_top_right").func_75216_d()) {
            this.func_238474_b_(stack, i + 35, j + 35, this.field_146999_f + 32, 0, 16, 16);
        }
        if (!((SignWorkbenchContainer)this.field_147002_h).getSlot("dye_bottom_left").func_75216_d()) {
            this.func_238474_b_(stack, i + 17, j + 53, this.field_146999_f + 32, 0, 16, 16);
        }
        if (!((SignWorkbenchContainer)this.field_147002_h).getSlot("dye_bottom_right").func_75216_d()) {
            this.func_238474_b_(stack, i + 35, j + 53, this.field_146999_f + 32, 0, 16, 16);
        }
    }

    protected Rectangle getResultCellBounds(int u, int v) {
        int left = this.field_147003_i + 64;
        int top = this.field_147009_r + 18;
        int cellSize = 18;
        int x = left + cellSize * u;
        int y = top + cellSize * v;
        return new Rectangle(x, y, cellSize, cellSize);
    }

    protected boolean renderResultCell(MatrixStack stack, ItemStack item, int index, int u, int v, int mouseX, int mouseY) {
        if (this.field_230706_i_ == null) {
            return false;
        }
        Rectangle bounds = this.getResultCellBounds(u, v);
        boolean hovering = bounds.contains(mouseX, mouseY);
        int textureY = hovering ? this.field_147000_g + 36 : this.field_147000_g;
        textureY = index == ((SignWorkbenchContainer)this.field_147002_h).getResultIndex() ? this.field_147000_g + 18 : textureY;
        this.field_230706_i_.func_110434_K().func_110577_a(this.background);
        this.func_238474_b_(stack, bounds.x, bounds.y, 0, textureY, bounds.width, bounds.height);
        this.field_230707_j_.func_180450_b(item, bounds.x + 1, bounds.y + 1);
        this.field_230707_j_.func_175030_a(this.field_230706_i_.field_71466_p, item, bounds.x + 1, bounds.y + 1);
        return hovering;
    }

    protected void renderResultCells(MatrixStack stack, int mouseX, int mouseY) {
        this.craftRecipe().ifPresent(recipe -> {
            NonNullList<ItemStack> results = recipe.getResults();
            int offset = this.getResultOffset(results.size());
            ItemStack tooltipItem = null;
            for (int i = 0; 0 <= i + offset && i + offset < results.size() && i < 9; ++i) {
                ItemStack item = (ItemStack)results.get(i + offset);
                if (!this.renderResultCell(stack, item, i + offset, i % 3, i / 3, mouseX, mouseY)) continue;
                tooltipItem = item;
            }
            if (tooltipItem != null) {
                this.func_230457_a_(stack, tooltipItem, mouseX, mouseY);
            }
        });
    }

    protected Rectangle getScrollButtonBounds() {
        return new Rectangle(this.field_147003_i + 122, this.scrollButtonY, 12, 15);
    }

    protected boolean canScroll(NonNullList<ItemStack> results) {
        boolean enoughResults = results.size() >= 9;
        boolean hoveringResultSlot = this.field_147006_u != null && this.field_147006_u.getSlotIndex() == ((SignWorkbenchContainer)this.field_147002_h).getResultSlot().getSlotIndex();
        return enoughResults && !hoveringResultSlot;
    }

    protected boolean canScroll() {
        return this.getRecipe().filter(recipe -> this.canScroll(recipe.getResults())).isPresent();
    }

    protected int clamp(int i, int min, int max) {
        return Math.max(Math.min(i, max), min);
    }

    protected void setScrollButtonY(int y, NonNullList<ItemStack> results) {
        Rectangle bounds = this.getScrollTroughBounds();
        this.scrollButtonY = this.canScroll(results) ? this.clamp(y, bounds.y, bounds.y + bounds.height) : bounds.y;
    }

    protected void scrollRows(int rows) {
        this.getRecipe().ifPresent(recipe -> {
            NonNullList<ItemStack> results = recipe.getResults();
            int totalRows = results.size() / 3;
            Rectangle bounds = this.getScrollTroughClickBounds();
            float rowHeight = (float)bounds.height / (float)totalRows;
            this.setScrollButtonY(this.scrollButtonY + (int)(rowHeight * (float)rows), results);
        });
    }

    protected void renderScrollButton(MatrixStack stack, int mouseX, int mouseY) {
        if (this.field_230706_i_ == null) {
            return;
        }
        this.field_230706_i_.func_110434_K().func_110577_a(this.background);
        Rectangle bounds = this.getScrollButtonBounds();
        int textureX = this.canScroll() ? 232 : 244;
        this.func_238474_b_(stack, bounds.x, bounds.y, textureX, 0, bounds.width, bounds.height);
    }

    protected void func_230450_a_(@Nonnull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(stack, partialTicks, mouseX, mouseY);
        this.renderSlotBackgrounds(stack);
        this.renderResultCells(stack, mouseX, mouseY);
        this.renderScrollButton(stack, mouseX, mouseY);
    }

    protected int getResultRow(int items) {
        Rectangle bounds = this.getScrollTroughBounds();
        float percent = (float)(this.scrollButtonY - bounds.y) / (float)bounds.height;
        return (int)(percent * (float)(items -= 6) / 3.0f);
    }

    protected int getResultOffset(int items) {
        return 3 * this.getResultRow(items);
    }

    protected void clickResultCell(double mouseX, double mouseY) {
        this.getRecipe().ifPresent(recipe -> {
            NonNullList<ItemStack> results = recipe.getResults();
            int offset = this.getResultOffset(results.size());
            for (int i = 0; i + offset < results.size() && i < 9; ++i) {
                Rectangle bounds = this.getResultCellBounds(i % 3, i / 3);
                if (!bounds.contains(mouseX, mouseY)) continue;
                if (this.field_230706_i_ == null) {
                    return;
                }
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                ((SignWorkbenchContainer)this.field_147002_h).setResultIndex(i + offset);
                return;
            }
        });
    }

    protected Rectangle getScrollTroughBounds() {
        return new Rectangle(this.field_147003_i + 122, this.field_147009_r + 17, 12, 41);
    }

    protected Rectangle getScrollTroughClickBounds() {
        return new Rectangle(this.field_147003_i + 122, this.field_147009_r + 17, 12, 56);
    }

    protected void clickScrollTrough(double mouseX, double mouseY) {
        this.getRecipe().ifPresent(recipe -> {
            boolean inBounds = this.getScrollTroughClickBounds().contains(mouseX, mouseY);
            if (!inBounds) {
                return;
            }
            this.isScrolling = true;
            this.setScrollButtonY((int)mouseY - 6, recipe.getResults());
        });
    }

    protected void dragScrollTrough(double mouseY) {
        this.getRecipe().ifPresent(recipe -> {
            if (this.isScrolling) {
                this.setScrollButtonY((int)mouseY - 6, recipe.getResults());
            }
        });
    }

    protected void addLabelsToRender(GenericContainerScreen.Labels labels) {
        super.addLabelsToRender(labels);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int buttonId) {
        this.clickResultCell(mouseX, mouseY);
        this.clickScrollTrough(mouseX, mouseY);
        return super.func_231044_a_(mouseX, mouseY, buttonId);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int buttonId) {
        this.isScrolling = false;
        return super.func_231048_c_(mouseX, mouseY, buttonId);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int buttonId, double wtf1, double wtf2) {
        this.dragScrollTrough(mouseY);
        return super.func_231045_a_(mouseX, mouseY, buttonId, wtf1, wtf2);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double sensitivity) {
        this.scrollRows(sensitivity < 0.0 ? 1 : -1);
        boolean b = super.func_231043_a_(mouseX, mouseY, sensitivity);
        SignsAndSignals.PACKETS.getChannel().sendToServer((Object)new SignWorkbenchScrollPacket(((SignWorkbenchContainer)this.field_147002_h).getSelectedRecipe()));
        return b;
    }
}

