/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.signs_and_signals.block;

import dev.sam.keys_and_leds_core.util.SafeBlockState;
import dev.sam.signs_and_signals.SignsAndSignals;
import dev.sam.signs_and_signals.block.GenericSteelPostBlock;
import dev.sam.signs_and_signals.state.properties.ModBlockStateProperties;
import dev.sam.signs_and_signals.tileentity.interfaces.INBTTunnel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteelPostCrossingLightsBlock
extends GenericSteelPostBlock {
    public SteelPostCrossingLightsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ModBlockStateProperties.X_TOP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ModBlockStateProperties.BEFORE_ONLY, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ModBlockStateProperties.START, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ModBlockStateProperties.RUN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape middle = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        ArrayList<VoxelShape> lights = new ArrayList<VoxelShape>();
        Boolean north = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D);
        Boolean east = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E);
        Boolean south = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F);
        Boolean west = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G);
        if (((Boolean)state.func_177229_b((Property)ModBlockStateProperties.X_TOP)).booleanValue()) {
            if (north.booleanValue()) {
                lights.add(Block.func_208617_a((double)0.0, (double)8.0, (double)0.5, (double)16.0, (double)15.0, (double)4.5));
            }
            if (east.booleanValue()) {
                lights.add(Block.func_208617_a((double)11.5, (double)0.0, (double)0.0, (double)15.5, (double)7.0, (double)16.0));
            }
            if (south.booleanValue()) {
                lights.add(Block.func_208617_a((double)0.0, (double)8.0, (double)11.5, (double)16.0, (double)15.0, (double)15.5));
            }
            if (west.booleanValue()) {
                lights.add(Block.func_208617_a((double)0.5, (double)0.0, (double)0.0, (double)4.5, (double)7.0, (double)16.0));
            }
        } else {
            if (north.booleanValue()) {
                lights.add(Block.func_208617_a((double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)7.0, (double)4.5));
            }
            if (east.booleanValue()) {
                lights.add(Block.func_208617_a((double)11.5, (double)8.0, (double)0.0, (double)15.5, (double)15.0, (double)16.0));
            }
            if (south.booleanValue()) {
                lights.add(Block.func_208617_a((double)0.0, (double)0.0, (double)11.5, (double)16.0, (double)7.0, (double)15.5));
            }
            if (west.booleanValue()) {
                lights.add(Block.func_208617_a((double)0.5, (double)8.0, (double)0.0, (double)4.5, (double)15.0, (double)16.0));
            }
        }
        return VoxelShapes.func_216384_a((VoxelShape)middle, (VoxelShape[])lights.toArray(new VoxelShape[0]));
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{BlockStateProperties.field_208151_D, BlockStateProperties.field_208152_E, BlockStateProperties.field_208153_F, BlockStateProperties.field_208154_G, ModBlockStateProperties.X_TOP, ModBlockStateProperties.BEFORE_ONLY, ModBlockStateProperties.START, ModBlockStateProperties.RUN, BlockStateProperties.field_208190_q, WATERLOGGED});
    }

    protected BlockState tryCopyLightsFrom(BlockState oldState, BlockState newState) {
        SafeBlockState safeOldState = SafeBlockState.of((BlockState)oldState);
        boolean north = safeOldState.getValue((Property)BlockStateProperties.field_208151_D).orElse(false);
        boolean east = safeOldState.getValue((Property)BlockStateProperties.field_208152_E).orElse(false);
        boolean south = safeOldState.getValue((Property)BlockStateProperties.field_208153_F).orElse(false);
        boolean west = safeOldState.getValue((Property)BlockStateProperties.field_208154_G).orElse(false);
        boolean xTop = safeOldState.getValue((Property)ModBlockStateProperties.X_TOP).orElse(false);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)newState.func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)ModBlockStateProperties.X_TOP, (Comparable)Boolean.valueOf(xTop));
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        boolean start = INBTTunnel.Block.tryGetData(world, pos.func_177977_b()).map(d -> d.func_74767_n("Start")).orElse(false);
        boolean run = INBTTunnel.Block.tryGetData(world, pos.func_177977_b()).map(d -> d.func_74767_n("Run")).orElse(false);
        FluidState fluidstate = use.func_195991_k().func_204610_c(use.func_195995_a());
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)ModBlockStateProperties.START, (Comparable)Boolean.valueOf(start))).func_206870_a((Property)ModBlockStateProperties.RUN, (Comparable)Boolean.valueOf(run))).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(start))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        Direction direction = use.func_196000_l().func_176734_d();
        BlockState oldState = world.func_180495_p(pos);
        state = this.tryCopyLightsFrom(oldState, state);
        switch (direction) {
            default: {
                if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D)).booleanValue()) break;
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(true));
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E)).booleanValue()) break;
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(true));
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F)).booleanValue()) break;
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(true));
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
                break;
            }
            case WEST: {
                if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G)).booleanValue()) break;
                state = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(true));
                world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        return state;
    }

    @Override
    public boolean tryPullDataUp(World world, BlockPos pos) {
        boolean hasData = super.tryPullDataUp(world, pos);
        boolean start = INBTTunnel.Block.tryGetData(world, pos).map(d -> d.func_74767_n("Start")).orElse(false);
        boolean run = INBTTunnel.Block.tryGetData(world, pos).map(d -> d.func_74767_n("Run")).orElse(false);
        BlockState state = world.func_180495_p(pos);
        boolean lit = (Boolean)state.func_177229_b((Property)ModBlockStateProperties.BEFORE_ONLY) != false ? start ^ run : start;
        world.func_175656_a(pos, (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)ModBlockStateProperties.START, (Comparable)Boolean.valueOf(start))).func_206870_a((Property)ModBlockStateProperties.RUN, (Comparable)Boolean.valueOf(run))).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(lit)));
        world.func_190524_a(pos.func_177984_a(), state.func_177230_c(), pos);
        return hasData;
    }

    @Override
    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean bool) {
        this.tryPullDataUp(state, world, pos, neighborPos);
    }

    protected void updateBlock(World world, BlockPos pos, PlayerEntity player, Hand hand, BlockState updated, BlockState postState) {
        boolean noLights;
        world.func_175656_a(pos, updated);
        boolean bl = noLights = (Boolean)updated.func_177229_b((Property)BlockStateProperties.field_208151_D) == false && (Boolean)updated.func_177229_b((Property)BlockStateProperties.field_208152_E) == false && (Boolean)updated.func_177229_b((Property)BlockStateProperties.field_208153_F) == false && (Boolean)updated.func_177229_b((Property)BlockStateProperties.field_208154_G) == false;
        if (noLights) {
            world.func_175656_a(pos, postState);
        }
        world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        ItemStack light = new ItemStack((IItemProvider)SignsAndSignals.BLOCKS.get("crossing_lights"));
        if (!player.func_184812_l_()) {
            this.addItemToPlayerInventory(player, hand, light);
        }
    }

    @Override
    protected void addItemToPlayerInventory(PlayerEntity player, Hand hand, ItemStack stack) {
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
        } else if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List stacks = super.func_220076_a(state, builder);
        ItemStack signal = new ItemStack((IItemProvider)SignsAndSignals.BLOCKS.get("crossing_lights"), 0);
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D)).booleanValue()) {
            signal.func_190917_f(1);
        }
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E)).booleanValue()) {
            signal.func_190917_f(1);
        }
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F)).booleanValue()) {
            signal.func_190917_f(1);
        }
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G)).booleanValue()) {
            signal.func_190917_f(1);
        }
        stacks.add(signal);
        return stacks;
    }

    protected void screwStanding(ItemUseContext use) {
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        BlockState updated = (BlockState)state.func_235896_a_((Property)ModBlockStateProperties.BEFORE_ONLY);
        boolean start = (Boolean)updated.func_177229_b((Property)ModBlockStateProperties.START);
        boolean run = (Boolean)updated.func_177229_b((Property)ModBlockStateProperties.RUN);
        boolean lit = (Boolean)updated.func_177229_b((Property)ModBlockStateProperties.BEFORE_ONLY) != false ? start ^ run : start;
        world.func_175656_a(pos, (BlockState)updated.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(lit)));
    }

    protected void screwCrouching(ItemUseContext use) {
        PlayerEntity player = use.func_195999_j();
        if (player == null) {
            return;
        }
        World world = use.func_195991_k();
        BlockPos pos = use.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        Hand hand = use.func_221531_n();
        Direction direction = use.func_195992_f().func_176734_d();
        DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, direction, use.func_195996_i(), direction);
        BlockState postState = ((Block)SignsAndSignals.BLOCKS.get("steel_post")).func_196258_a((BlockItemUseContext)context);
        if (postState == null) {
            return;
        }
        switch (direction) {
            default: {
                if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D)).booleanValue()) break;
                this.updateBlock(world, pos, player, hand, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208151_D, (Comparable)Boolean.valueOf(false)), postState);
                break;
            }
            case EAST: {
                if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E)).booleanValue()) break;
                this.updateBlock(world, pos, player, hand, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208152_E, (Comparable)Boolean.valueOf(false)), postState);
                break;
            }
            case SOUTH: {
                if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F)).booleanValue()) break;
                this.updateBlock(world, pos, player, hand, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208153_F, (Comparable)Boolean.valueOf(false)), postState);
                break;
            }
            case WEST: {
                if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G)).booleanValue()) break;
                this.updateBlock(world, pos, player, hand, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208154_G, (Comparable)Boolean.valueOf(false)), postState);
            }
        }
    }

    @Override
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)SignsAndSignals.BLOCKS.get("crossing_lights"));
    }

    @Override
    public void screw(ItemUseContext use) {
        PlayerEntity player = use.func_195999_j();
        if (player == null) {
            return;
        }
        if (player.func_225608_bj_()) {
            this.screwCrouching(use);
        } else {
            this.screwStanding(use);
        }
    }
}

